% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.global_envelope2d}
\alias{plot.global_envelope2d}
\title{Plotting function for 2d global envelopes}
\usage{
\method{plot}{global_envelope2d}(
  x,
  fixedscales = TRUE,
  what = c("obs", "lo", "hi", "lo.sign", "hi.sign"),
  sign.col = "red",
  transparency = 155/255,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A 'global_envelope' object for two-dimensional functions}

\item{fixedscales}{Logical. TRUE for the same scales for all images.}

\item{what}{Character vector specifying what information should be plotted for 2d functions.
A combination of:
Observed (\code{"obs"}), upper envelope (\code{"hi"}), lower envelope (\code{"lo"}),
observed with significantly higher values highlighted (\code{"hi.sign"}),
observed with significantly lower values highlighted (\code{"lo.sign"}).}

\item{sign.col}{The color for the observed curve when outside the global envelope
(significant regions). Default to "red". Setting the color to \code{NULL} corresponds
to no coloring. If the object contains several envelopes, the coloring is done for
the widest one.}

\item{transparency}{A number between 0 and 1 (default 155/255, 60% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions for 2d
functions.}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{...}{Ignored.}
}
\description{
If more than one envelope has been calculated (corresponding to several coverage/alpha),
only the largest one is plotted.
}
