% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepCounter.R
\name{stepCounter}
\alias{stepCounter}
\title{Step Counter}
\usage{
stepCounter(
  data,
  samplefreq = 100,
  filterorder = 2,
  boundaries = c(0.5, 5),
  Rp = 3,
  plot.it = FALSE,
  hysteresis = 0.05,
  verbose = verbose,
  fun = c("GENEAcount", "mean", "sd", "mad")
)
}
\arguments{
\item{data}{The data to use for calculating the steps. This should either an AccData/GENEAbin object or a vector.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number (default 100).}

\item{filterorder}{single integer, order of the Chebyshev bandpass filter,
passed to argument n of \code{\link[signal]{cheby1}}.}

\item{boundaries}{length 2 numeric vector specifying lower and upper bounds
of Chebychev filter (default \code{c(0.5, 5)} Hz),
passed to argument W of \code{\link[signal]{butter}} or \code{\link[signal]{cheby1}}.}

\item{Rp}{the decibel level that the cheby filter takes, see \code{\link[signal]{cheby1}}.}

\item{plot.it}{single logical create plot of data and zero crossing points (default \code{FALSE}).}

\item{hysteresis}{The hysteresis applied after zero crossing. (default 100mg)}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default FALSE).}

\item{fun}{character vector naming functions by which to summarize steps.
"count" is an internally implemented summarizing function that returns step count.}
}
\value{
Returns a vector with length fun.
}
\description{
Function to calculate the number and variance of the steps in the data.
}
\examples{
d1 <- sin(seq(0.1, 100, 0.1))/2 + rnorm(1000)/10 + 1
Steps4 = stepCounter(d1)
length(Steps4)
mean(Steps4)
sd(Steps4)
plot(Steps4)
}
