% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_Difference_29102018.R
\name{Fuzzy.Difference}
\alias{Fuzzy.Difference}
\title{Calculates the difference between two fuzzy numbers}
\usage{
Fuzzy.Difference(X, Y, alphacuts = FALSE, breakpoints = 100)
}
\arguments{
\item{X}{a fuzzy number of any type.}

\item{Y}{a fuzzy number of any type.}

\item{alphacuts}{fixed by default to "FALSE". No alpha-cuts are printed in this case.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}
}
\value{
If the parameter alphacuts="TRUE", the function returns a matrix composed by 2 vectors representing the left and right alpha-cuts. For this output, is.alphacuts = TRUE. If the parameter alphacuts="FALSE", the function returns a trapezoidal fuzzy number given by the quadruple (p,q,r,s), such that p \eqn{\le} q \eqn{\le} r \eqn{\le} s.
}
\description{
Calculates the difference between two fuzzy numbers
}
\examples{
X <- TrapezoidalFuzzyNumber(5,6,7,8)
Y <- TrapezoidalFuzzyNumber(1,2,3,4)
Fuzzy.Difference(X,Y)
}
