% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCI_ML_boot_13012018.R
\name{fci.ml.boot}
\alias{fci.ml.boot}
\title{Estimates a fuzzy confidence interval by the Likelihood method}
\usage{
fci.ml.boot(
  data.fuzzified,
  t,
  distribution,
  sig,
  coef.boot,
  mu = NA,
  sigma = NA,
  step = 0.05,
  margin = c(5, 5),
  breakpoints = 100,
  plot = TRUE
)
}
\arguments{
\item{data.fuzzified}{a fuzzification matrix constructed by a call to the function FUZZ or the function GFUZZ, 
or a similar matrix. No NA are allowed.}

\item{t}{a given numerical or fuzzy type parameter of the distribution.}

\item{distribution}{a distribution chosen between "normal", "poisson", "Student" or "Logistic".}

\item{sig}{a numerical value representing the significance level of the test.}

\item{coef.boot}{a decimal representing the 1-sig-quantile of the bootstrap distribution of LR.}

\item{mu}{if the mean of the normal distribution is known, mu should be a numerical value. Otherwise, the argument mu is fixed to NA.}

\item{sigma}{if the standard deviation of the normal distribution is known, sigma should be a numerical value. Otherwise, the argument sigma is fixed to NA.}

\item{step}{a numerical value fixed to 0.05, defining the step of iterations on the interval [t-5; t+5].}

\item{margin}{an optional numerical couple of values fixed to [5; 5], representing the range of calculations around the parameter t.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{plot}{fixed by default to "FALSE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a matrix composed by 2 vectors representing the numerical left and right alpha-cuts. For this output, is.alphacuts = TRUE.
}
\description{
Estimates a fuzzy confidence interval by the Likelihood method
}
\examples{
data <- matrix(c(1,2,3,2,2,1,1,3,1,2),ncol=1) 
MF111 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF112 <- TrapezoidalFuzzyNumber(1,2,2,3)
MF113 <- TrapezoidalFuzzyNumber(2,3,3,4)
PA11 <- c(1,2,3)
data.fuzzified <- FUZZ(data,mi=1,si=1,PA=PA11)
Fmean <- Fuzzy.sample.mean(data.fuzzified)
fci.ml.boot(data.fuzzified, t = Fmean, distribution = "normal", sig= 0.05, sigma = 0.62,
coef.boot = 1.8225)
}
