% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{addrule}
\alias{addrule}
\title{Inserts a rule}
\usage{
addrule(fis, ruleList)
}
\arguments{
\item{fis}{A fis structure is to be provided.}

\item{ruleList}{A vector of length m + n + 2, where m is the number of input variables of a fis. \cr Each column in 'm' has a number which refers to the membership function of that input variable. \cr Columns under 'n' refer to an output variable of a fis, where the value refers to the membership function of that output variable. \cr Finally, the '2' remaining columns refer to the weight to be applied to the rule (m + n + 1) and the fuzzy operator for the rule's antecedent (1 = AND, 2 = OR).}
}
\value{
A fis structure with the new rule added.
}
\description{
Adds a rule to a fis object.
}
\details{
For example, if one has a fis with 2 input variables, and 1 output variable, each of which have 3 membership functions (the amount of membership functions need not be the same). The following rule: 1 3 2 1 2 will mean m = 2 (for 2 input variables), n = 1 (for 1 output variable), and the last 2 columns represent weight and fuzzy operator for the rule's antecedent respectively. \cr\cr
The first column refers to the first input variable's membership function at index 1.\cr\cr
The second column refers to the second input variable's membership function at index 3.\cr\cr
The third column refers to the first output variable's membership function at index 2.\cr\cr
The fourth column refers to the weight to be applied to the rule.\cr\cr
The fifth column refers to the fuzzy operator for the rule's antecedent (in this case it represents 'OR').
}
\examples{
fis <- tipper()
ruleList <- rbind(c(1,1,1,1,2), c(2,0,2,1,1), c(3,2,3,1,2))
fis <- addrule(fis, ruleList)
}
