% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyWASPAS.R
\name{FuzzyWASPAS}
\alias{FuzzyWASPAS}
\title{Implementation of Fuzzy WASPAS Method for Multi-Criteria Decision Making Problems.}
\usage{
FuzzyWASPAS(decision, weights, cb, lambda)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x (\emph{n}*3)) with the values of the \emph{m} alternatives, for the \emph{n} criteria, and multiplied by 3 since they are triangular fuzzy numbers.}

\item{weights}{A vector of length \emph{n}*3, containing the fuzzy weights for the criteria.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}

\item{lambda}{A value in [0,1]. It is used in the calculation of the W index.}
}
\value{
\code{FuzzyWASPAS} returns a data frame which contains the score of the W index and the ranking of the alternatives.
}
\description{
The \code{FuzzyWASPAS} function implements the Fuzzy Weighted Aggregated Sum Product ASsessment (Fuzzy WASPAS) Method.
}
\examples{

 d <- matrix(c(0.5,0.6,0.6,0.6,0.6,0.7,0.7,0.7,0.7,0.8,0.8,0.8,0.6,0.6,0.8,0.5,0.7,0.7,
 0.9,0.6,0.8,0.8,1,0.7,0.8,0.5,0.6,0.6,0.9,0.6,0.7,0.7,1,0.7,0.8,0.8,0.5,0.6,0.5,0.4,0.6,
 0.7,0.6,0.5,0.7,0.8,0.7,0.6,0.8,0.7,0.6,0.5,0.9,0.8,0.7,0.6,1,0.9,0.8,0.7,0.5,0.8,0.6,
 0.8,0.6,0.9,0.7,0.9,0.7,1,0.8,1,0.4,0.5,0.8,0.7,0.5,0.6,0.9,0.8,0.6,0.7,1,0.9,0.5,0.4,
 0.4,0.5,0.6,0.5,0.5,0.6,0.7,0.6,0.6,0.7),nrow=4,ncol=24)
 w <- c(0.21,0.28,0.35,0.16,0.20,0.23,0.14,0.16,0.17,0.09,0.12,0.17,0.07,0.08,0.12,0.05,
 0.06,0.09,0.03,0.05,0.07,0.01,0.03,0.06)
 cb <- c('max','max','max','max','max','max','max','max')
 lambda <- 0.49
 FuzzyWASPAS(d,w,cb,lambda)
}
\references{
Turskis, Z. and Zavadskas, E. K. and Antucheviciene, J. and Kosareva, N. A Hybrid Model Based on Fuzzy AHP and Fuzzy WASPAS for Construction Site Selection. International Journal of Computers Communications & Control, 10(6), 873-888, 2015.
}

