% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputationTests.R
\name{ImputationTests}
\alias{ImputationTests}
\title{Battery of test for the imputed fuzzy values.}
\usage{
ImputationTests(
  trueData,
  imputedData,
  imputedMask,
  trapezoidal = TRUE,
  cutsNumber = 100,
  K = 50,
  ...
)
}
\arguments{
\item{trueData}{Name of the input matrix (or data frame) with the true values of the variables.}

\item{imputedData}{Name of the input matrix (or data frame) with the imputed values.}

\item{imputedMask}{Matrix (or data frame) with logical values where \code{TRUE} indicates the cells with the imputed values.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{cutsNumber}{Number of cuts for the epistemic bootstrap tests.}

\item{K}{Value of \code{K} for the \code{res} epistemic test.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a list of the matrices: \code{trueValues} - the true, input values (the same as \code{trueData}),
\code{mask} - the masked (NAs) values (the same as \code{imputedMask}),
\code{nonFNNumbers} - the vector with the numbers of non-FNs samples for each variable,
\code{errorMatrix} -- the output from the function \code{ErrorMatrix},
\code{statisticalMeasures} -- the output from the function \code{StatisticalMeasures}, 
 \code{statisticalTests} -- the output from the function \code{ApplyStatisticalTests}, 
\code{fuzzyMeasures} -- the output from the function \code{CalculateFuzzyMeasures}.
}
\description{
`ImputationTests` calculates various measures and applies goodness-of-fit statistical tests to
check the quality of the imputed fuzzy values.
}
\details{
The procedure uses other functions embedded in this package to check the quality of the imputed fuzzy values if they
are compared with the original ones.
This procedure calculates number of non-FNs for each variable, error matrix (using \code{ErrorMatrix}), various statistical measures 
(with \code{StatisticalMeasures}), applies epistemic goodness-of-fit tests (using \code{ApplyStatisticalTests}), and evaluates the
fuzzy measures (with \code{CalculateFuzzyMeasures}).
Therefore, this function can be directly applied as one-click benchmark tool.

To properly distinguish the real values with their imputed counterparts, the additional matrix \code{imputedMask} should be provided.
In this matrix, the logical value \code{TRUE} points out the cells with the imputed values.
Otherwise, \code{FALSE} should be used.

All of the input datasets can be given as matrices or data frames.
}
\examples{

# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)

# add some NAs to the matrix

matrix1NA <- IntroducingNA(matrix1,percentage = 0.1)

head(matrix1NA)

# impute missing values

matrix1DImp <- ImputationDimp(matrix1NA)

# find cells with NAs

matrix1Mask <- is.na(matrix1NA)

# check the quality of the imputed values

ImputationTests(matrix1,matrix1DImp,matrix1Mask,trapezoidal=TRUE)



}
