% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcc_biclust.R
\name{funcc_biclust}
\alias{funcc_biclust}
\title{Functional Cheng and Church algorithm}
\usage{
funcc_biclust(
  fun_mat,
  delta,
  theta = 1,
  template.type = "mean",
  number = 100,
  alpha = 0,
  beta = 0,
  const_alpha = FALSE,
  const_beta = FALSE,
  shift.alignement = FALSE,
  shift.max = 0.1,
  max.iter.align = 100
)
}
\arguments{
\item{fun_mat}{The data array (n x m x T) where each entry corresponds to the measure of one observation i, i=1,...,n, for a functional variable m, m=1,...,p, at point t, t=1,...,T}

\item{delta}{scalar: Maximum of accepted score, should be a real value > 0}

\item{theta}{scalar: Scaling factor should be a real value > 1}

\item{template.type}{character: type of template required. If template.type='mean' the template is evaluated as the average function, if template.type='medoid' the template is evaluated as the medoid function.}

\item{number}{integer: Maximum number of iteration}

\item{alpha}{binary: if alpha=1 row shift is allowed, if alpha=0 row shift is avoided}

\item{beta}{binary: if beta=1 row shift is allowed, if beta=0 row shift is avoided}

\item{const_alpha}{logicol: Indicates if row shift is contrained as constant.}

\item{const_beta}{logicol: Indicates if col shift is contrained as constant.}

\item{shift.alignement}{logicol: If shift.alignement=True the shift aligment is performed, if shift.alignement=False no alignment is performed}

\item{shift.max}{scalar: shift.max controls the maximal allowed shift, at each iteration, in the alignment procedure with respect to the range of curve domains. t.max must be such that 0<shift.max<1}

\item{max.iter.align}{integer: maximum number of iteration in the alignment procedure}
}
\value{
a list of two elements containing respectively the Biclustresults and a dataframe containing the parameters setting of the algorithm
 @examples  
data("funCCdata")
res <- funcc_biclust(funCCdata,delta=10,theta=1,alpha=1,beta=0,const_alpha=TRUE)
res
}
\description{
The funCC algorithm allows to simultaneously cluster the rows and the columns of a data matrix where each entry of the matrix is a function or a time series
}
