% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linterp.R
\name{linterp}
\alias{linterp}
\title{Linearly interpolate missing values in a numeric vector}
\usage{
linterp(x, max_allow = 3)
}
\arguments{
\item{x}{The numeric vector to interpolate. The first and last element must
not be \code{NA}, otherwise an error is generated.}

\item{max_allow}{Maximum number of consecutive missing values to allow. If
there is any number of consecutive \code{NA} values in \code{x} longer than
\code{max_allow}, the function will fail with an error. Set to \code{NULL} to
fully disable this check.}
}
\value{
The numeric vector \code{x}, with any missing values replaced by
linear interpolants.
}
\description{
This value fills in missing values (\code{NA}s) in a numeric vector by
linear interpolation
}
\details{
This function can be handy when running \code{\link{fitFluMoDL}}, for
example to fill in small gaps in the temperatures vector.
But it can be more generally useful as well.
}
