% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.station.metadata.R
\name{remove.station.metadata}
\alias{remove.station.metadata}
\title{Remove MetaData for one station from database}
\usage{
remove.station.metadata(Agency, StationID)
}
\arguments{
\item{Agency}{string indicating the source of the streamflow data, e.g. USGS, WSC, etc. Cannot be NA.}

\item{StationID}{string, cannot be NA.}
}
\value{
The metadata of the removed station if found and removed, or NULL if not found.
}
\description{
Removes a station's metadata from the package database based on the Agency and StationID.
If the agency is "USGS" and the station is not found, it will also check by adding a "0" 
to the beginning of the StationID. Used to remove a case added in error.
}
\examples{

# Add station metadata
met_added <- add.station.metadata(
  Agency = "Foo Bar",
  StationID = "01234",
  StnName = "Example Station",
  StateProv = "Example State",
  Country = "Example Country",
  Lat = 40.0,
  Lon = -89.0,
  CatchmentArea_km2 = 500,
  RHN = TRUE,
  StationID_Alternate = "01234A",
  Overwrite = FALSE
)


# Remove the added station metadata
met_removed <- remove.station.metadata(
  Agency = "Foo Bar",
  StationID = "01234"
)
}
