% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr.seas.R
\name{dr.seas}
\alias{dr.seas}
\title{Find the start, middle, end, and duration of seasonal droughts}
\usage{
dr.seas(
  TS,
  Qdr = 0.2,
  WinSize = 30,
  IntEventDur = 10,
  EventDur = 15,
  Season = c(4:9)
)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{Qdr}{Numeric value for drought quantile.  Default is 0.2.}

\item{WinSize}{Numeric value for moving window size in days.
Default is 30.}

\item{IntEventDur}{Numeric value for the minimum inter-event duration in 
days. Drought events with less than the specified number of days between will 
be pooled and considered as one event. Default is 10.}

\item{EventDur}{Numeric value for the minimum drought duration in days. Default
is 15.}

\item{Season}{Numeric vector of months during which droughts start. Default 
is c(4:9) for non-frost season droughts.}
}
\value{
Returns a data.frame of drought event metrics; the columns are:
  \itemize{
    \item StartDay - day of year that the drought event started on
    \item MidDay - day of year for the middle of the drought event, which is
      defined as the day when the cumulative drought deficit reached 50% of the
      total cumulative daily streamflow deficit.  Total cumulative streamflow 
      deficit is also referred to as drought severity in this package.
    \item EndDay - day of year that the drought ended on
    \item Duration - length of the drought event, in days
    \item Severity - severity of the drought event, calculated as the total
      cumulative daily streamflow deficit
  }
  
  The "times" attribute provides the start date to preserve year information
  and aid in plotting the time series.
}
\description{
This function returns the day of year for the start, middle, and end of 
seasonal droughts.  It also returns the duration and severity of each drought
event. The function allows for seasonal analysis by defining a season 
argument which lists months during which droughts of interest may start.
}
\details{
This function calls \code{\link{dr.events}} which calls 
  \code{\link{dr.pds}} and \code{\link{mqt}}
}
\examples{
data(cania.sub.ts)
res <- dr.seas(cania.sub.ts)
res2 <- screen.metric(res[,1], "Day of Year")
}
\seealso{
See \code{\link{create.ts}} to format the input flow series. \cr
  See \code{\link{dr.events}} and \code{\link{mqt}} for details on how drought 
  events are defined.
}
\author{
Jennifer Dierauer
}
