% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqt.r
\name{mqt}
\alias{mqt}
\title{Moving quantile threshold}
\usage{
mqt(TS, Qdr = 0.2, WinSize = 30)
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{Qdr}{Numeric value of the drought threshold quantile.  Default is 0.2.}

\item{WinSize}{Numeric value specifying the size of the moving window in
days.  Default is 30.}
}
\value{
Returns a numeric vector containing the streamflow drought threshold
  in m3/s for each day of the year.
}
\description{
This function calculates the daily moving window quantile threshold for use in 
identifying the partial duration series of streamflow droughts.
}
\details{
The threshold is defined by a moving quantile, where daily threshold 
  values are based on the 80th percentile of the flow duration curve 
  (i.e. 0.2 quantile) from a 30-day moving window (Beyene et al. 2014). 
  With this method, every day of the year has a different threshold based on 
  the streamflow measured on the day, the 15 days before 
  the day, and the 15 days after the day.The size of the moving window can be 
  modified with the WinSize argument, and the percentile can be modified with the
  Qdr argument.
}
\examples{
data(cania.sub.ts)
res <- mqt(cania.sub.ts)

# subset one year of the flow series
flow.sub <- cania.sub.ts[cania.sub.ts$year == 1990,]

# plot the 1990 observed flows in dark blue and the daily drought threshold in red
plot(flow.sub$doy, flow.sub$Flow, ylab="Q (m3/s)", xlab="Day of Year",
 pch=19, col="darkblue", type="b")
points(res, pch=19, cex=0.7, col="red")
}
\references{
Beyene, B.S., Van Loon, A.F., Van Lanen, H.A.J., Torfs, P.J.J.F., 2014. 
  Investigation of variable threshold level approaches for hydrological drought 
  identification. Hydrol. Earth Syst. Sci. Discuss. 11, 12765-12797. 
  http://dx.doi.org/10.5194/hessd-11-12765-2014.
}
\seealso{
See \code{\link{create.ts}} to format the input flow series.

  The following functions use this function: \code{\link{dr.pds}}, 
  \code{\link{dr.events}}, \code{\link{dr.seas}}
}
\author{
Jennifer Dierauer
}
