% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynloglikMC.R
\name{dynloglikMC}
\alias{dynloglikMC}
\title{Log-likelihood of a Lognormal-GPD dynamic mixture}
\usage{
dynloglikMC(x, y, nreps)
}
\arguments{
\item{x}{(6 by 1) numerical vector: values of the parameters CA1, CA2, meanlog, sdlog, xi, beta.}

\item{y}{vector: points where the function is evaluated.}

\item{nreps}{non-negative integer: number of replications to be used in the computation of the integral in the normalizing
constant.}
}
\value{
Log-likelihood of the lognormal-GPD mixture evaluated at y.
}
\description{
This function evaluates the log-likelihood of a Lognormal-GPD dynamic mixture,
approximating the normalizing constant via Monte Carlo simulation.
}
\examples{
llik <- dynloglikMC(c(1,2,0,1,.25,3.5),Metro2019,10000)
}
\keyword{dynamic}
\keyword{mixture.}
