% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynloglik.R
\name{dynloglik}
\alias{dynloglik}
\title{Log-likelihood of a Lognormal-GPD dynamic mixture}
\usage{
dynloglik(x, y, intTol)
}
\arguments{
\item{x}{(6 by 1) numerical vector: values of CA1, CA2, meanlog, sdlog, xi, beta.}

\item{y}{vector: points where the function is evaluated.}

\item{intTol}{non-negative scalar: threshold for stopping the computation of the integral in the normalization
constant: if the integral on the interval from n-1 to n is smaller than intTol, the approximation procedure stops.}
}
\value{
log-likelihood of the lognormal-GPD mixture evaluated at y.
}
\description{
This function evaluates the log-likelihood of a Lognormal-GPD dynamic mixture, computing the integral in the normalizing constant via quadrature methods.
}
\examples{
x <- c(1,2,0,.5,.25,3.5)
y <- rDynMix(100,x)
fit <- dynloglik(x,y,1e-06)
}
\keyword{dynamic}
\keyword{mixture.}
