% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENoisyFitBoot.R
\name{CENoisyFitBoot}
\alias{CENoisyFitBoot}
\title{Estimating a dynamic mixture via noisy Cross-Entropy and computing
bootstrap standard errors}
\usage{
CENoisyFitBoot(yObs, nboot, rho, maxiter, alpha, nsim, nrepsInt, eps, r = 5)
}
\arguments{
\item{yObs}{numerical vector: observed random sample from the mixture.}

\item{nboot}{integer: number of bootstrap replications for computing the standard errors.
If nboot = 0, no standard errors are computed.}

\item{rho}{real in (0,1): parameter determining the quantile of the log-likelihood values to be used at each iteration.}

\item{maxiter}{non-negative integer: maximum number of iterations.}

\item{alpha}{real in (0,1): smoothing parameter.}

\item{nsim}{non-negative integer: number of replications used in the normal and lognormal updating.}

\item{nrepsInt}{non-negative integer: number of replications used in the Monte Carlo estimate of the normalizing constant.}

\item{eps}{non-negative real: tolerance for the stopping criterion of the noisy Cross-Entropy method.}

\item{r}{positive integer: length of window to be used in the stopping criterion.}
}
\value{
If nboot > 0, a list with the following elements:

estPars: Cross-Entropy estimates.

nit: number of iterations needed for convergence.

loglik: maximized log-likelihood.

bootPars: parameter estimates obtained for each bootstrap sample.

stddev: bootstrap standard errors.

If nboot = 0, only estPars, nit and loglik are returned.
}
\description{
This function estimates a dynamic mixture by means of the noisy Cross-Entropy
method and computes bootstrap standard errors.
Currently only implemented for the lognormal - generalized Pareto case. Bootstrap
standard errors are computed in parallel.
}
\examples{
res = CENoisyFitBoot(Metro2019,0,.05,20,.5,500,500,.01)
}
\keyword{Cross-Entropy;}
\keyword{bootstrap.}
\keyword{dynamic}
\keyword{mixture;}
\keyword{non-parametric}
