% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{procsom}
\alias{procsom}
\title{Processing of self-organizing maps for pseudo-temporal expression profiles}
\usage{
procsom(s1d, corthr = 0.85, minsom = 3)
}
\arguments{
\item{s1d}{output of function \code{getsom}}

\item{corthr}{correlation threshold, i. e. a real number between 0 and 1. The z-score of the average normalized pseudo-temporal expression profiles within each node of the self-organizing map is computed, and the correlation of these z-scores between neighbouring nodes is computed. If the correlation is greater than \code{corthr}, neighbouring nodes are merged. Default value is 0.85.}

\item{minsom}{positive integer number. Nodes of the self-organizing map with less than \code{minsom} transcripts are discarded. Default value is 3.}
}
\value{
A list of the following seven components:
\item{k}{vector of Pearson's correlation coefficient between node \code{i} and node \code{i+1} of the populated nodes of the self-organizing map.}
\item{nodes}{vector with assignment of genes to nodes of the final self-organizing map (after merging). Components are node numbers and component names are gene IDs.}
\item{nodes.e}{data frame with average normalized pseudo-temporal expression profile for each node, ordered by node number.}
\item{nodes.z}{data frame with z-score transformed average normalized pseudo-temporal expression profile for each node, ordered by node number.}
\item{all.e}{data frame with normalized pseudo-temporal expression profile for all genes in the self-organizing map, ordered by node number.}
\item{all.z}{data frame with z-score transformed normalized pseudo-temporal expression profile for all genes in the self-organizing map, ordered by node number.}
\item{all.b}{data frame with binarized pseudo-temporal expression profile for all genes in the self-organizing map, ordered by node number. Expression is 1 in cells with z-score > 1 and -1 in cells with z-score < -1, and 0 otherwise.}
}
\description{
This function processes the self-organizing maps produced by the function \code{getsom}.
}
\examples{

\donttest{
x <- intestine$x
y <- intestine$y
v <- intestine$v

tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,lle.n=30,dm.sigma=1000,dm.distance="euclidean",tsne.perplexity=30)
pr <- prcurve(y,fb,dr,k=2,m="cmd",trthr=0.4,start=NULL)
n <- pr$trc[["t6"]]
fs  <- filterset(v,n,minexpr=2,minnumber=1)
s1d <- getsom(fs,nb=1000,k=5,locreg=TRUE,alpha=.5)
ps <- procsom(s1d,corthr=.85,minsom=3)
}

}
