% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{impGenes}
\alias{impGenes}
\title{Extract genes with high importance values for random forest classification}
\usage{
impGenes(fb, tn, ithr = 0.02, zthr = 2)
}
\arguments{
\item{fb}{fateBias object returned by the function \code{fateBias}. If \code{fb} is provided, then a principal curve is computed and shown in the plot. Default value is \code{NULL}. The curve is only displayed if \code{g} equal \code{NULL}.}

\item{tn}{name of a target cluster, i. e. concatenation of a \code{t} and the number of a target cluster. Has to correspond to a column name of \code{fb$probs}.}

\item{ithr}{positive real number. Threshold for the required importance measure (mean decrease in accuracy of classification upon removal, see \pkg{randomForest}) to include a gene into the output as important feature for classying cells in \code{tn}. Default value is 0.02.}

\item{zthr}{positive real number. Threshold for the required z-score of the importance measure (importance divided by the standard deviation of importance) to include a gene into the output as important feature for classying cells in \code{tn}. Default value is 2.}
}
\value{
The function returns a list of two elements.
\item{d}{a data frame with mean importance values for all genes surviving the filtering by \code{ithr} and \code{zthr}. Columns correspond to random forest iterations, starting from the initial target cluster.}
\item{d}{a data frame with the standard deviation of importance values for all genes surviving the filtering by \code{ithr} and \code{zthr}. Columns correspond to random forest iterations, starting from the initial target cluster.}
The function produces a heatmap of \code{d} with hierarchical clustering of the rows using the function \code{pheatmap} from the \pkg{pheatmap} package.
}
\description{
This function extracts all genes with an importance value for classifying cells into a given target cluster exceeding a given threshold for at least one of the random forest iterationns.
}
\examples{
x <- intestine$x
y <- intestine$y
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
k <- impGenes(fb,"t6",ithr=.02,zthr=2)
}
