% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{rownamesToCol}
\alias{rownamesToCol}
\title{Convert Row Names to a Column}
\usage{
rownamesToCol(df, colname = "rownames")
}
\arguments{
\item{df}{A data frame.}

\item{colname}{A character string specifying the name of the new column to
contain the row names. Defaults to "rownames".}
}
\value{
A data frame with the row names converted to a column.
}
\description{
This function converts the row names of a data frame to a specified column.
Note that if the specified column already exists, it is overwritten.
}
\examples{
# Convert row names to a column named 'ID'
df <- data.frame(Value = c(10, 20, 30))
rownames(df) <- c("A", "B", "C")
rownamesToCol(df, "ID")
}
\keyword{wrangling}
