% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectSlope}
\alias{selectSlope}
\title{Select slope}
\usage{
selectSlope(data, class, featureEval, s.threshold = 0.8)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{s.threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
}
}
\description{
Selects features (in descending order from the best evaluation measure to the lowest) until the slope to the next feature is over a threshold. The slope is calculated as: (s.threshold) / (number of features)
}
\examples{
## Select Slope for iris dataset (filter method)
selectSlope(iris, 'Species', IEPConsistency, 0.8)
}
\author{
Adan M. Rodriguez
}
