# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Selection Cutoffs for Ranked Attributes
#'
#' @param x1 Vector with attributes' names.
#' @param x2 Vector with attributes' ranks for cut off.
#' @param k A numeric. For \code{k >= 1} it indicates how many attributes to take
#' with the highest attribute rank (chooses k best attributes). For \code{0 < k < 1} it stands for the fraction
#' of top attributes to take (chooses best k * 100% of attributes).
#'
#' @author Damian Skrzypiec, \email{damian.j.skrzypiec@@gmail.com}
#'
#' @examples
#'
#' x <- information_gain(Species ~ ., iris)
#' cutOff_k(x[[1]], x[[2]], 2)
#'
#' @noRd
cutOff_k <- function(x1, x2, k) {
    .Call(`_FSelectorRcpp_cutOff_k`, x1, x2, k)
}

discretize_cpp <- function(x, y, discControl) {
    .Call(`_FSelectorRcpp_discretize_cpp`, x, y, discControl)
}

information_gain_cpp <- function(xx, y, threads = 1L) {
    .Call(`_FSelectorRcpp_information_gain_cpp`, xx, y, threads)
}

sparse_information_gain_cpp <- function(x, y) {
    .Call(`_FSelectorRcpp_sparse_information_gain_cpp`, x, y)
}

fs_count_levels <- function(x) {
    .Call(`_FSelectorRcpp_fs_count_levels`, x)
}

fs_order <- function(x) {
    .Call(`_FSelectorRcpp_fs_order`, x)
}

fs_entropy1d <- function(x) {
    .Call(`_FSelectorRcpp_fs_entropy1d`, x)
}

fs_table1d <- function(x) {
    .Call(`_FSelectorRcpp_fs_table1d`, x)
}

fs_table_numeric2d <- function(x, y) {
    .Call(`_FSelectorRcpp_fs_table_numeric2d`, x, y)
}

