% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/WalleyeMN06a.R
\docType{data}
\name{WalleyeMN06a}
\alias{WalleyeMN06a}
\title{Catch-at-age for Walleye.}
\format{A data frame with 52 observations on the following 3 variables.
 \describe{
   \item{lake}{A factor vector of collection lake (Crooked, Fourmile, Island, Tom).}
   \item{age}{A numeric vector of assigned ages (from dorsal spines).}
   \item{number}{A numeric vector of number of fish.}
 }}
\source{
Data from various tables in Borkholder, B.D., A.J. Edwards, and C. Olson. 2007.  \href{http://www.1854treatyauthority.org/cms/files/REP\%20Fish\%20Walleye\%20Survey\%202006.pdf}{Spring adult and fall juvenile walleye popluation surveys within the 1854 ceded territory of Minnesota, 2006.}  Fond du Lac Division of Resource Management, Technical Report 41.
}
\description{
Catch-at-age for Walleye (\emph{Sander vitreus}) collected from four lakes in Northern Minnesota, USA.
}
\section{Topic(s)}{

 \itemize{
   \item Mortality
   \item Catch curve
 }
}
\examples{
data(WalleyeMN06a)
str(WalleyeMN06a)
head(WalleyeMN06a)
op <- par(mfrow=c(2,2),pch=19)
plot(log(number)~age,data=WalleyeMN06a,subset=lake=="Crooked")
plot(log(number)~age,data=WalleyeMN06a,subset=lake=="Fourmile")
plot(log(number)~age,data=WalleyeMN06a,subset=lake=="Island")
plot(log(number)~age,data=WalleyeMN06a,subset=lake=="Tom")
par(op)
}
\concept{
Mortality 'Catch Curve'
}
\keyword{datasets}

