% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{repeatedRows2Keep}
\alias{repeatedRows2Keep}
\title{Find non-repeated consecutive rows in a data.frame.}
\usage{
repeatedRows2Keep(
  df,
  cols2use = NULL,
  cols2ignore = NULL,
  keep = c("first", "last")
)
}
\arguments{
\item{df}{A data.frame.}

\item{cols2use}{A string or numeric vector that indicates columns in \code{df} to use. Negative numeric values will not use those columns. Cannot use both \code{cols2use} and \code{col2ignore}.}

\item{cols2ignore}{A string or numeric vector that indicates columns in \code{df} to ignore. Cannot use both \code{cols2use} and \code{col2ignore}.}

\item{keep}{A string that indicates whether the \code{first} (DEFAULT) or \code{last} row of consecutive repeated rows should be kept.}
}
\value{
A single logical that indicates which rows of \code{df} to keep such that no consecutive rows (for the columns used) will be repeated.
}
\description{
Finds the rows in a data.frame that are not repeats of the row immediately above or below it.
}
\examples{
test1 <- data.frame(ID=1:10,
                    KEEP=c("First","Last","Both","Both","Both",
                           "Both","First","Neither","Last","Both"),
                    V1=c("a","a","a","B","b","B","A","A","A","a"),
                    V2=c("a","a","A","B","B","b","A","A","A","a"))
keepFirst <- repeatedRows2Keep(test1,cols2ignore=1:2)
keepLast <- repeatedRows2Keep(test1,cols2use=3:4,keep="last")
data.frame(test1,keepFirst,keepLast)

droplevels(subset(test1,keepFirst))  # should be all "First" or "Both" (7 items)
droplevels(subset(test1,keepLast))   # should be all "Last" or "Both" (7 items)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
