context("Catch Curve and Chapman-Robson OUTPUT")
source("EXS_CatchCurve.R")

test_that("catchCurve() outpute types",{
  expect_is(cc,"catchCurve")
  # coef, unweighted
  ccA <- coef(cc)
  expect_true(is.vector(ccA))
  expect_is(ccA,"numeric")
  expect_equal(length(ccA),2)
  expect_equal(names(ccA),c("Z","A"))
  ccA <- coef(cc,parm="Z")
  expect_true(is.vector(ccA))
  expect_is(ccA,"numeric")
  expect_equal(length(ccA),1)
  expect_equal(names(ccA),c("Z"))
  ccA <- coef(cc,parm="lm")
  expect_true(is.vector(ccA))
  expect_is(ccA,"numeric")
  expect_equal(length(ccA),2)
  expect_equal(names(ccA),c("(Intercept)","age.e"))
  # coef, weighted
  cc2A <- coef(cc2)
  expect_true(is.vector(cc2A))
  expect_is(cc2A,"numeric")
  expect_equal(length(cc2A),2)
  expect_equal(names(cc2A),c("Z","A"))
  cc2A <- coef(cc2,parm="A")
  expect_true(is.vector(cc2A))
  expect_is(cc2A,"numeric")
  expect_equal(length(cc2A),1)
  expect_equal(names(cc2A),c("A"))
  cc2A <- coef(cc2,parm="lm")
  expect_true(is.vector(cc2A))
  expect_is(cc2A,"numeric")
  expect_equal(length(cc2A),2)
  expect_equal(names(cc2A),c("(Intercept)","age.e"))
  # confint, unweighted
  ccA <- confint(cc)
  expect_is(ccA,"matrix")
  expect_equal(mode(ccA),"numeric")
  expect_equal(nrow(ccA),2)
  expect_equal(ncol(ccA),2)
  expect_equal(rownames(ccA),c("Z","A"))
  expect_equal(colnames(ccA),c("95% LCI","95% UCI"))
  ccA <- confint(cc,parm="Z")
  expect_is(ccA,"matrix")
  expect_equal(mode(ccA),"numeric")
  expect_equal(nrow(ccA),1)
  expect_equal(ncol(ccA),2)
  expect_equal(rownames(ccA),c("Z"))
  expect_equal(colnames(ccA),c("95% LCI","95% UCI"))
  ccA <- confint(cc,parm="lm")
  expect_is(ccA,"matrix")
  expect_equal(mode(ccA),"numeric")
  expect_equal(nrow(ccA),2)
  expect_equal(ncol(ccA),2)
  expect_equal(rownames(ccA),c("(Intercept)","age.e"))
  expect_equal(colnames(ccA),c("95% LCI","95% UCI"))
  # confint, weighted
  cc2A <- confint(cc2)
  expect_is(cc2A,"matrix")
  expect_equal(mode(cc2A),"numeric")
  expect_equal(nrow(cc2A),2)
  expect_equal(ncol(cc2A),2)
  expect_equal(rownames(cc2A),c("Z","A"))
  expect_equal(colnames(cc2A),c("95% LCI","95% UCI"))
  cc2A <- confint(cc2,parm="Z")
  expect_is(cc2A,"matrix")
  expect_equal(mode(cc2A),"numeric")
  expect_equal(nrow(cc2A),1)
  expect_equal(ncol(cc2A),2)
  expect_equal(rownames(cc2A),c("Z"))
  expect_equal(colnames(cc2A),c("95% LCI","95% UCI"))
  cc2A <- confint(cc2,parm="lm")
  expect_is(cc2A,"matrix")
  expect_equal(mode(cc2A),"numeric")
  expect_equal(nrow(cc2A),2)
  expect_equal(ncol(cc2A),2)
  expect_equal(rownames(cc2A),c("(Intercept)","age.e"))
  expect_equal(colnames(cc2A),c("95% LCI","95% UCI"))
  # summary
  cc2A <- summary(cc2)
  expect_is(cc2A,"matrix")
  expect_equal(mode(cc2A),"numeric")
  expect_equal(nrow(cc2A),2)
  expect_equal(ncol(cc2A),4)
  expect_equal(rownames(cc2A),c("Z","A"))
  expect_equal(colnames(cc2A),c("Estimate","Std. Error","t value","Pr(>|t|)"))
  cc2A <- summary(cc2,parm="Z")
  expect_is(cc2A,"matrix")
  expect_equal(mode(cc2A),"numeric")
  expect_equal(nrow(cc2A),1)
  expect_equal(ncol(cc2A),4)
  expect_equal(rownames(cc2A),c("Z"))
  expect_equal(colnames(cc2A),c("Estimate","Std. Error","t value","Pr(>|t|)"))
  cc2A <- summary(cc2,parm="lm")
  expect_is(cc2A,"summary.lm")

  # r-squared
  expect_true(is.numeric(rSquared(cc)))
  expect_true(is.numeric(rSquared(cc2)))
  
  # anova
  expect_equal(anova(cc2),anova(cc2$lm))
})

test_that("chapmanRobson() output types",{
  expect_is(cr,"chapmanRobson")
  # coef
  crA <- coef(cr)
  expect_true(is.vector(crA))
  expect_is(crA,"numeric")
  expect_equal(length(crA),2)
  expect_equal(names(crA),c("S","Z"))
  crA <- coef(cr,parm="S")
  expect_true(is.vector(crA))
  expect_is(crA,"numeric")
  expect_equal(length(crA),1)
  expect_equal(names(crA),c("S"))
  # summary
  crA <- summary(cr)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("Estimate","Std. Error"))
  crA <- summary(cr,parm="S")
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),1)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S"))
  expect_equal(colnames(crA),c("Estimate","Std. Error"))
  # confint
  crA <- confint(cr)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("95% LCI","95% UCI"))
  crA <- confint(cr,parm="S")
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),1)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S"))
  expect_equal(colnames(crA),c("95% LCI","95% UCI"))
  
  expect_is(cr1,"chapmanRobson")
  # coef
  crA <- coef(cr1)
  expect_true(is.vector(crA))
  expect_is(crA,"numeric")
  expect_equal(length(crA),2)
  expect_equal(names(crA),c("S","Z"))
  # summary
  crA <- summary(cr1)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("Estimate","Std. Error"))
  # confint
  crA <- confint(cr1)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("95% LCI","95% UCI"))
  expect_is(cr1,"chapmanRobson")
  
  # coef
  crA <- coef(cr2)
  expect_true(is.vector(crA))
  expect_is(crA,"numeric")
  expect_equal(length(crA),2)
  expect_equal(names(crA),c("S","Z"))
  # summary
  crA <- summary(cr2)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("Estimate","Std. Error"))
  # confint
  crA <- confint(cr2)
  expect_is(crA,"matrix")
  expect_equal(mode(crA),"numeric")
  expect_equal(nrow(crA),2)
  expect_equal(ncol(crA),2)
  expect_equal(rownames(crA),c("S","Z"))
  expect_equal(colnames(crA),c("95% LCI","95% UCI"))
})

test_that("catchCurve() and ChaptmanRobson() handle NA values properly.",{
  ## matches for catchCurve
  df <- data.frame(age=1:10,n=c(90,164,162,110,55,41,20,14,7,5))
  cc1 <- catchCurve(n~age,data=df,ages2use=3:10)
  scc1 <- summary(cc1)
  cc2 <- catchCurve(n~age,data=df,ages2use=3:10,weighted=TRUE)
  scc2 <- summary(cc2)  
  
  dfA <- data.frame(age=0:12,n=c(NA,90,164,162,110,55,41,20,14,7,5,NA,NA))
  cc1A <- catchCurve(n~age,data=dfA,ages2use=3:12)
  scc1A <- summary(cc1A)
  cc2A <- catchCurve(n~age,data=dfA,ages2use=3:12,weighted=TRUE)
  scc2A <- summary(cc2A) 
  
  expect_equal(scc1["Z","Estimate"],scc1A["Z","Estimate"])
  expect_equal(scc1["Z","Std. Error"],scc1A["Z","Std. Error"])
  expect_equal(scc2["Z","Estimate"],scc2A["Z","Estimate"])
  expect_equal(scc2["Z","Std. Error"],scc2A["Z","Std. Error"])
  
  ## matches for chapmanRobson
  cr1 <- chapmanRobson(n~age,data=df,ages2use=3:10)
  scr1 <- summary(cr1)
  
  cr1A <- chapmanRobson(n~age,data=dfA,ages2use=3:12)
  scr1A <- summary(cr1A)
  
  expect_equal(scr1["Z","Estimate"],scr1A["Z","Estimate"])
  expect_equal(scr1["Z","Std. Error"],scr1A["Z","Std. Error"])
  expect_equal(scr1["S","Estimate"],scr1A["S","Estimate"])
  expect_equal(scr1["S","Std. Error"],scr1A["S","Std. Error"])
})

test_that("catchCurve() and ChaptmanRobson() does negative ages2use properly.",{
  ## matches for catchCurve
  df <- data.frame(age=1:10,n=c(90,164,162,110,55,41,20,14,7,5))
  cc1 <- catchCurve(n~age,data=df,ages2use=3:10)
  scc1 <- summary(cc1)
  cc2 <- catchCurve(n~age,data=df,ages2use=-(1:2))
  scc2 <- summary(cc2)  
  expect_equal(cc1,cc2)
  expect_equal(scc1,scc2)
  
  cr1 <- chapmanRobson(n~age,data=df,ages2use=3:10)
  scr1 <- summary(cr1)
  cr2 <- chapmanRobson(n~age,data=df,ages2use=-(1:2))
  scr2 <- summary(cr2)
  expect_equal(cr1,cr2)
  expect_equal(scr1,scr2)
})
