% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{headtail}
\alias{headtail}
\title{Shows rows from the head and tail of a data frame or matrix.}
\usage{
headtail(x, n = 3L, which = NULL, addrownums = TRUE, ...)
}
\arguments{
\item{x}{A data frame or matrix.}

\item{n}{A single numeric that indicates the number of rows to display from each of the head and tail of structure.}

\item{which}{A numeric or string vector that contains the column numbers or names to display.  Defaults to showing all columns.}

\item{addrownums}{If there are no row names for the MATRIX, then create them from the row numbers.}

\item{\dots}{Arguments to be passed to or from other methods.}
}
\value{
A matrix or data.frame with 2*n rows.
}
\description{
Shows rows from the head and tail of a data frame or matrix.
}
\note{
If \code{n} is larger than the number of rows in \code{x} then all of \code{x} is displayed.
}
\examples{
headtail(iris)
headtail(iris,10)
headtail(iris,which=c("Sepal.Length","Sepal.Width","Species"))
headtail(iris,which=grep("Sepal",names(iris)))
headtail(iris,n=200)

## Make a matrix for demonstration purposes only
miris <- as.matrix(iris[,1:4])
headtail(miris)
headtail(miris,10)
headtail(miris,addrownums=FALSE)
headtail(miris,10,which=2:4)

## Make a tbl_df type from dplyr ... note how headtail()
## is not limited by the tbl_df restriction on number of
## rows to show (but head() is).
if (require(dplyr)) {
  iris2 <- tbl_df(iris)
  class(iris2)
  headtail(iris2,n=15)
  head(iris2,n=30)
}
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
