% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_olfreg.R
\name{predict.olfreg}
\alias{predict.olfreg}
\title{Predict OLFREG model}
\usage{
\method{predict}{olfreg}(object, ..., newdata = NULL, type = c("probabilities", "labels"))
}
\arguments{
\item{object}{OLFREG model for which predictions are computed}

\item{...}{additional arguments relevant for the generic method}

\item{newdata}{an optional argument. Newdata should be organized as a list. The elements of the list
are covariates from OLFREG model, respectively. No data transformation is needed. Thus, functional covariates are entered in the list \code{newdata}
in their raw form. The \code{predict.olfreg} function will take care of the transformation of such covariates into the functional form of their equivalents from OLFREG model.}

\item{type}{c("probabilities", "labels")}
}
\value{
predictions of dependent variable \code{y}
}
\description{
Prediction of OLFREG model
}
\examples{
\donttest{
# cycling dataset
library(fda)
# creation of ordinal variable from HR variable
zoneHR=rep(0,216)
zoneHR[which(rowMeans(cycling$HR[,1:1700])<107)]=1
zoneHR[which((rowMeans(cycling$HR[,1:1700])<125)&(rowMeans(cycling$HR[,1:1700])>107))]=2
zoneHR[which((rowMeans(cycling$HR[,1:1700])<142)&(rowMeans(cycling$HR[,1:1700])>125))]=3
zoneHR[which((rowMeans(cycling$HR[,1:1700])<160)&(rowMeans(cycling$HR[,1:1700])>142))]=4
zoneHR[which((rowMeans(cycling$HR[,1:1700])>160))]=5
# first functional variable - power (WATTS)
watts = t(cycling$WATTS[,1:1700])
# set up a fourier basis system due to its cycling pattern
xbasis = create.fourier.basis(c(1,1700),50) # 50 basis functions for example
watts.fd = smooth.basis(c(1:1700),watts,xbasis)$fd
zoneHR = as.factor(zoneHR)
# additional functional variable - cadence (CAD)
cad = t(cycling$CAD[,1:1700])
# set up a functional variable for cad
xbasis2 = create.bspline.basis(c(1,1700), nbasis = 25, norder = 4)
cad.fd = smooth.basis(c(1:1700),cad,xbasis2)$fd
formula = zoneHR ~ watts.fd + cad.fd
olfreg.model = olfreg(formula = formula)

# Predict with new data included
watts_new = t(cycling$WATTS[,101:1800])
cad_new = t(cycling$CAD[,101:1800])
newdata = list(watts_new, cad_new) # could also be fd var instead of raw data
yhat = predict(olfreg.model, newdata = newdata, type = "labels")
}
}
