% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freg.R
\name{freg}
\alias{freg}
\title{Functional linear regression model}
\usage{
freg(formula, betalist = NULL)
}
\arguments{
\item{formula}{a formula expression of the form \code{response ~ predictors}. On the left side of the formula, \code{y} is a numeric variable whereas on the right side,
\code{X} can be either functional data object of class \code{fd} or a scalar variable of class \code{numeric}. The length of a scalar variable must equal the length
of a response variable. Similarly, the number of observations of a functional covariate must equal the length of a response variable.}

\item{betalist}{an optional argument. A list which contains beta regression coefficient functions for independent variables.
If betalist is not provided, the number of estimated beta regression coefficient functions for one functional covariate would equal the number of basis functions used to represent that functional covariate.
For a scalar variable, beta regression coefficient function is also a functional object whose basis is constant.
Needless to say, for a scalar variable, there will be one beta regression coefficient.}
}
\value{
\item{call}{ call of the lfreg function}

\item{x.count}{ number of predictors}

\item{xfdlist}{ a list of functional data objects. The length of the list is equal to the number of predictors}

\item{betalist}{ a list of beta regression coefficient functions}

\item{coefficients}{  estimated beta regression coefficient functions}
}
\description{
Functional linear regression model in which the response variable is a scalar variable
whereas the independent variables are functional variables. Independent variables could also be scalar variables.
}
\examples{
library(fda)
y = log10(apply(daily$precav,2,sum))
x = daily$tempav
xbasis = create.fourier.basis(c(1,365),5) # 5 basis functions
# smoothing of the data and extraction of functional data object
xfd=smooth.basis(c(1:365),x,xbasis)$fd
formula = y ~ xfd
# betalist is an optional argument
bbasis = create.fourier.basis(c(1,365),5) # 5 basis functions
betalist = list(bbasis)
freg.model = freg(formula = formula, betalist = betalist)

# Functional variable and two scalar variables
latitude = CanadianWeather$coordinates[,1]
longitude = CanadianWeather$coordinates[,2]
xfdlist = list(xfd, latitude, longitude)
cbasis = create.constant.basis(c(1,365))
betalist = list(bbasis, cbasis, cbasis)
formula = y ~ xfd + latitude + longitude
freg.model = freg(formula = formula, betalist = betalist)
print(freg.model$coefficients)

}
