% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Drp.R
\name{Drp}
\alias{Drp}
\title{Distributed random projection}
\usage{
Drp(data,K, nk,d)
}
\arguments{
\item{data}{is  sparse random projection matrix}

\item{K}{is  the number of distributed nodes.}

\item{nk}{is the size of subsets.}

\item{d}{is the dimension number.
n is the sample size.
p the number of variables.}
}
\value{
MSEXrp, MSEvrp, MSESrp, kopt
}
\description{
Distributed random projection
}
\examples{
K=20; nk=50; nr=10; p=8; d=5; n=K*nk;
data=matrix(c(rnorm((n-nr)*p,0,1),rpois(nr*p,100)),ncol=p)
data=matrix(rpois((n-nr)*p,1),ncol=p); rexp(nr*p,1); rchisq(10000, df = 5);
Drp(data=data,K=K, nk=nk,d=d)
}
