% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_desc.R, R/spatial_functions.R
\name{spatial_desc}
\alias{spatial_desc}
\alias{polyfix.sf}
\alias{build.prj4str}
\alias{trunc10shp}
\alias{merge_extents}
\alias{check.extents}
\alias{getprjatt}
\alias{areacalc.poly}
\alias{checksf.longlat}
\alias{crsCompare}
\alias{sf_dissolve}
\alias{closest_poly}
\alias{getIntersect}
\alias{clip.othertables}
\alias{check.area}
\title{Spatial Data Functions}
\usage{
polyfix.sf(x)

build.prj4str(
  prj,
  datum = NULL,
  ellps = NULL,
  zone = NULL,
  zoneS = FALSE,
  aea.param = "USGS",
  gui = FALSE
)

trunc10shp(x)

merge_extents(layer1, layer2)

check.extents(
  bbox1,
  bbox2,
  showext = FALSE,
  layer1nm = NULL,
  layer2nm = NULL,
  stopifnotin = FALSE,
  quiet = FALSE
)

getprjatt(prj4str, prjatt, stopifnull = FALSE)

areacalc.poly(
  polyv,
  polyv_dsn = NULL,
  areaprj = "aea",
  zone = NULL,
  unit = "ACRES",
  areavar = NULL
)

checksf.longlat(x, nolonglat = TRUE, crs.default = NULL)

crsCompare(
  x,
  ycrs = NULL,
  x.crs = NULL,
  nolonglat = FALSE,
  checkonly = FALSE,
  crs.default = NULL
)

sf_dissolve(sflayer, col = NULL, areacalc = TRUE)

closest_poly(x.centroid, ypoly, ypoly.att = NULL, nbr = NULL, returnsf = TRUE)

getIntersect(layer1, layer2, layer1.unique, layer2fld, overlapThreshold = 0)

clip.othertables(
  inids,
  othertabnms,
  othertabs = NULL,
  uniqueid = "PLT_CN",
  savedata = FALSE,
  outfn.pre = NULL,
  outfolder = NULL,
  out_fmt = "csv",
  out_dsn = NULL,
  outfn.date = FALSE,
  overwrite_layer = FALSE,
  gui = FALSE
)

check.area(bnd, bnd_dsn, bnd.att = NULL, areaunits = "acres", min.area = 6000)
}
\value{
Spatial data object from `sf`. Used for spatial data analyses.
}
\description{
These functions allow for analysis and manipulation of spatial data. Tasks
include but are not limited to analyzing polygons, comparing projections,
and checking data compatibility.
}
\details{
These functions carry out spatial data analysis.
}
\author{
Tracey S. Frescino
}
\keyword{internal}
