% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetStates.R
\name{spGetStates}
\alias{spGetStates}
\title{Spatial wrapper - Extracts states that intersect a boundary.}
\usage{
spGetStates(
  bnd_layer,
  bnd_dsn = NULL,
  bnd.filter = NULL,
  stbnd.att = "COUNTYFIPS",
  RS = NULL,
  states = NULL,
  overlap = 1,
  clipbnd = FALSE,
  showsteps = FALSE,
  savebnd = FALSE,
  savedata_opts = NULL
)
}
\arguments{
\item{bnd_layer}{sf R object, Area of Interest (AOI) boundary. Can be a spatial 
sf object, full pathname to a shapefile, or name of a layer within a database.}

\item{bnd_dsn}{String. Data source name (dsn; e.g., SQLite database or shapefile
pathname) of bnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html).}

\item{bnd.filter}{String. Filter to subset bnd spatial layer.}

\item{stbnd.att}{String. Attribute in stunitco to output ('STATECD',
'STATENM', 'COUNTYFIPS').}

\item{RS}{String. Name of FIA research station to restrict states to
('RMRS','SRS','NCRS','NERS','PNWRS'). If NULL, all research stations are
included.}

\item{states}{String. States to subset boundary to.}

\item{overlap}{Number. Percent overlap to include.}

\item{clipbnd}{Logical. If TRUE, clips boundary to state/RS restrictions.}

\item{showsteps}{Logical. If TRUE, display intersecting boundaries.}

\item{savebnd}{Logical. If TRUE, save boundary to outfolder.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savebnd = TRUE.}
}
\value{
A list containing states and state names that the boundary crosses,
and boundary and attribute information for the intersecting boundary.
}
\description{
Wrapper to get state names that intersect a given boundary.
}
\examples{
# Get polygon vector layer from FIESTA external data
WYbhdistfn <- system.file("extdata", 
                          "sp_data/WYbighorn_districtbnd.shp",
                          package = "FIESTA")

# Get intersecting statenames
spGetStates(WYbhdistfn)$statenames

# Get intersecting COUNTYFIP codes
spGetStates(WYbhdistfn,
            stbnd.att = "COUNTYFIPS")$states
}
\author{
Tracey S. Frescino
}
\keyword{data}
