% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spReprojectRaster.R
\name{spReprojectRaster}
\alias{spReprojectRaster}
\title{Spatial - Reprojects an Esri shapefile (*shp) or S4 Spatial object.}
\usage{
spReprojectRaster(
  rastfn,
  bands = NULL,
  crs = NULL,
  rast.ref = NULL,
  crs.new = NULL,
  res.new = NULL,
  bbox.new = NULL,
  dtype.new = NULL,
  NODATA.new = NULL,
  resamp.method = "near",
  crs.default = "EPSG:5070",
  compress = NULL,
  BigTIFF = FALSE,
  outfolder = NULL,
  outfn = NULL,
  outext = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{rastfn}{String or Raster. File name(s) with extensions, or raster
object(s).  Note: raster objects must be written to file.}

\item{bands}{Numeric vector. If rast is a multi-layer raster and only 1 or
some layers are desired, specify layer number(s) in a vector format. If
NULL, all layers are projected.}

\item{crs}{Coordinate Reference System (CRS). The CRS of rastfn if not
defined.  EPSG:code, PROJ.4 declaration, or .prj file containing WKT. For
example, PROJ.4: "+proj=moll +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84
+datum=WGS84 +units=m +no_defs".  If NULL, and the CRS of rastfn is not
defined, uses crs.default.}

\item{rast.ref}{String or Raster. File name(s) with extensions, or raster
object to use as reference raster.}

\item{crs.new}{Coordinate Reference System. New CRS for rastfn.  EPSG:code,
PROJ.4 declaration, or .prj file containing WKT. For example, PROJ.4:
"+proj=moll +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m
+no_defs".}

\item{res.new}{Integer vector. One or two values defining new resolution of
raster (in target georeferenced units) (e.g., 30 or c(30,30)).}

\item{bbox.new}{<xmin ymin xmax ymax> Georeferenced extent or bounding box
of new raster.}

\item{dtype.new}{String. Force a data type of new raster. If NULL, the data
type will be same as rastfn (e.g., Byte, Int16, UInt16).}

\item{NODATA.new}{Integer. Set nodata values for new raster. New files will
be initialized to this value and if possible the nodata value will be
recorded in the output file. Use a value of "None" to ensure that nodata is
not defined. If NULL, NODATA and rastfn has a set NODATA value, this value
will be used for new raster.}

\item{resamp.method}{Method for resampling ('near', 'bilinear', 'cubic',
'cubicspline', 'landzos', 'average', 'mode', 'min', 'max', 'med', 'q1',
'q3').}

\item{crs.default}{Coordinate Reference System. A default CRS if
crs.new=NULL.  The default is: EPSG:5070, Conus Albers, PRJ4='+proj=aea
+lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96, +x_0=0 +y_0=0", "+ellps=GRS80
+towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs'.}

\item{compress}{String. An optional compression type ('LZW', "DEFLATE',
"PACKBITS').}

\item{BigTIFF}{Logical. If TRUE, compress option for big files (> 4GB).}

\item{outfolder}{String. If exportsp=TRUE, name of output folder. If NULL,
the working directory is used.}

\item{outfn}{String. Name of output raster. If NULL, default is 'polyrast'.}

\item{outext}{String. Name of raster extension (fmt). If NULL, uses
extension from outfn or rastfn.}

\item{overwrite}{Logical. If TRUE, overwrites raster file.}
}
\value{
\item{rastfn.new}{ String. Full path name to reprojected raster. }
}
\description{
Reprojects an Esri shapefile (*.shp) or S4 Spatial object to a new
geographic or projected coordinate system, with option to save new object.
}
\note{
Coordinate Reference Systems (CRS)\cr An ellipse is an estimated model
describing the basic shape of the Earth and is the basis for all coordinate
systems. There are many ellipsoids designed for local (e.g., NAD27) or
global (e.g., WGS84, GRS80) use. The datum defines the reference position of
the coordinate axes associated with a specific ellipsoid. Specifying the
datum also defines the ellipsoid, whereas specifying the ellipsoid does not
provide information of the datum.

WGS84 vs NAD83 WGS84 and NAD83 datums are often used interchangeably, and
use very similar ellipsoids (WGS84 and GRS80, respectively), but have
different reference points. Slight tectonic shifts through time have caused
increased divergence between the two, with NAD83 datum intended to track
movements more consistently.

Common Datums and associated spheroid (ellipsoid):\cr NAD27 - North American
Datum of 1927 (Clarke 1866 spheroid)\cr NAD83 - North American Datum of 1983
(GRS 1980 spheroid)\cr WGS84 - World Geodetic System of 1984 (WGS 1984
spheroid)\cr

From R, use projInfo for list of different projections and datums.\cr >
projInfo(type="proj")\cr > projInfo(type="datum")\cr

Common EPSG Geodetic codes in U.S.\cr EPSG:4326 - Longitude/Latitude (WGS84)
- Common for global displays (used by Google Earth)\cr EPSG:4269 -
Longitude/Latitude (NAD83) - Common by U.S. Federal Agencies\cr

The sf::st_transform (GDAL) method is used for map projection conversion and
datum transformation using PROJ.4 arguments. Datum transformation only
occurs if the +datum tag is present in the both the from and to PROJ.4
strings. The +towgs84 tag is used when no datum transformation is needed.
PROJ.4 transformations assume NAD83 and WGS84 are identical unless other
transformation parameters are specified. Be aware, providing inaccurate or
incomplete CRS information may lead to erroneous data shifts when
reprojecting. See spTransform help documentation for more details.
}
\examples{
\donttest{
# Get raster layers from FIESTA external data
demfn <- system.file("extdata",
                     "sp_data/WYbighorn_dem_250m.img",
                     package = "FIESTA")

# Plot original projection
raster::plot(raster::raster(demfn))

# Check original projection
sf::st_crs(raster::raster(demfn))$proj4string

# Reproject raster
reprojected <- spReprojectRaster(rastfn = demfn,
                                 crs.new = "EPSG:32613",
                                 outfolder = tempdir())
                                 
# Plot new projection
raster::plot(raster::raster(reprojected))

# Check new projection
sf::st_crs(raster::raster(reprojected))$proj4string
}
}
\author{
Tracey S. Frescino, Chris Toney
}
\keyword{spatial}
