% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modPBpop.R
\name{modPBpop}
\alias{modPBpop}
\title{Photo-Based module - Generate population data for PB module.}
\usage{
modPBpop(
  pntdat = NULL,
  pltpct = NULL,
  plotid = "plot_id",
  pntid = NULL,
  pltpctvars = NULL,
  plt = NULL,
  pltassgn = NULL,
  puniqueid = "CN",
  pltassgnid = "CN",
  nonsamp.pfilter = NULL,
  sumunits = FALSE,
  unitvar = NULL,
  unitarea = NULL,
  areavar = "ACRES",
  strata = FALSE,
  strtype = "POST",
  stratalut = NULL,
  strvar = "STRATUMCD",
  pvars2keep = NULL,
  saveobj = FALSE,
  objnm = "PBpopdat",
  savedata = FALSE,
  unit_opts = NULL,
  strata_opts = NULL,
  savedata_opts = NULL,
  PBstratdat = NULL,
  gui = FALSE
)
}
\arguments{
\item{pntdat}{DF/DT or comma-delimited file (*.csv). Point-level table with
one record per point. If NULL, aggregated point counts must be in pntcnt.}

\item{pltpct}{DF/DT or comma-delimited file (*.csv). Plot-domain-level table
with percent observed by domain per plot.}

\item{plotid}{String. Unique identifier of plot in pnt. All values must
match puniqueid values, if pltassgn is not NULL.}

\item{pntid}{String. Unique identifier of points in pnt.}

\item{pltpctvars}{String vector. Variables in pltpct for estimation. If
NULL, all variables are used except plotid in pltpct.}

\item{plt}{DF/DT, comma-separated values (CSV) file(*.csv), or layer in dsn,
Can also be a shapefile(*.shp) with one record per plot, a spatial layer in
dsn, or a sf R object. Plot-level variables. If nonsampled plots are
included, PLOT_STATUS_CD variable must be in table. Optional.}

\item{pltassgn}{DF/DT, comma-delimited file(*.csv), SpatialDataFrame, or
shapefile(*.shp). The plot-level data with one record per plot, including
estimation unit and/or strata information. Optional.}

\item{puniqueid}{String. Unique identifier of plot.}

\item{pltassgnid}{String. Name of unique identifier of plot in pltassgn with
All values must match plotid values if pnt is not NULL.}

\item{nonsamp.pfilter}{String. An expression for filtering nonsampled plots.
Must be R syntax.}

\item{sumunits}{Logical. If TRUE, estimation units are combined to one table
for output. Note: only available if tabtype="AREA". Acres}

\item{unitvar}{String. Name of the estimation unit variable in cond or
pltassgn with estimation unit assignment for each plot (e.g., 'ESTN_UNIT').
If one estimation unit, set unitvar=NULL.}

\item{unitarea}{Numeric or DF. Total area by estimation unit. If only 1
estimation unit, include number of total acreage for the area of interest or
a data frame with areavar. If more than one estimation unit, provide a data
frame of total area by estimation unit, including unitvar and areavar.}

\item{areavar}{String. Name of acre variable in unitarea. Default="ACRES".}

\item{strata}{Logical. If TRUE, add data information for stratification.}

\item{strtype}{String. If strata=TRUE, the type of strata ('POST', 'PRE').
Note: the variance equations are slighlty different.}

\item{stratalut}{DF/DT. If strata=TRUE, look-up table with strata
proportions ('strwt') by strata (and estimation unit). To calculate 'strwt',
set getwt=TRUE and getwtvar= name of variable with information to calculate
weights from (e.g., pixel counts)}

\item{strvar}{String. If strata=TRUE, name of the strata variable in
stratalut and cond or pltassgn data frame with stratum assignment for each
plot (Default = 'STRATUMCD').}

\item{pvars2keep}{String vector. Additional plot variables to keep in
dataset.}

\item{saveobj}{Logical. If TRUE, saves SApopdat object to outfolder.}

\item{objnm}{String. Name of *.rda object.}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{unit_opts}{List. See help(unit_options()) for a list of options.}

\item{strata_opts}{List. See help(strata_options()) for a list of options.
Only used when strata = TRUE.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{PBstratdat}{R List object. Output data list components from
FIESTA::DBgetStrata().}

\item{gui}{Logical. If gui, user is prompted for parameters.}
}
\value{
A list with population data for Green-Book estimates.

\item{condx}{ Data frame. Condition-level data including plot-level
assignment of estimation unit and stratum (if strata=TRUE) and adjusted
condition proportion. } \item{pltcondx}{ Data frame. Condition-level data,
merged with plot data. } \item{cuniqueid}{ String. Unique identifier of plot
in condx and pltcondx. } \item{condid}{ String. Unique identifier of
condition in condx and pltcondx. } \item{treex}{ Data frame. If
esttype='TREE', tree-level data, including sample adjustment factor. }
\item{tuniqueid}{ String. If esttype='TREE', unique identifier of plot in
treex. } \item{ACI.filter}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD
== 1" . } \item{unitarea}{ String. Returned table of area by estimation
unit. } \item{unitvar}{ String. Variable name for estimation unit. }
\item{strlut}{ String. Strata-level table with pixel counts by strata
(P1POINTCNT), strata weights (strwt), number of plots by strata (n.strata),
total number of plots in estimation unit (n.total), sum of condition
proportions (*_UNADJ_SUM), area adjustments (*_ADJFAC), total area, and area
expansion by strata (EXPNS). } \item{strvar}{ String. Variable name for
strata. If strata=FALSE, strvar="ONESTRAT". } \item{expcondtab}{ String. If
ACI=FALSE, ACI.filter="COND_STATUS_CD == 1" . } \item{plotsampcnt}{ Data
frame. Number of plots by PLOT_STATUS_CD. } \item{condsampcnt}{ Data frame.
Number of conditions by COND_STATUS_CD. } \item{states}{ String. State names
in dataset. } \item{invyrs}{ String. Range of inventory years in dataset. }

\item{stratdat}{ Data frame. Strata information by estimation unit. }
\tabular{lll}{ \tab \bold{Variable} \tab \bold{Description}\cr \tab unitvar
\tab estimation unit \cr \tab strvar \tab stratum value \cr \tab strwtvar
\tab number of pixels by strata and estimation unit \cr \tab n.strata \tab
number of plots in strata (after totally nonsampled plots removed) \cr \tab
n.total \tab number of plots for estimation unit \cr \tab strwt \tab
proportion of area (or plots) by strata and estimation unit (i.e., strata
weight) \cr \tab CONDPROP_UNADJ_SUM \tab summed condition proportion by
strata and estimation unit \cr \tab CONDPROP_ADJFAC \tab adjusted condition
proportion by strata after nonsampled plots removed \cr \tab AREA_USED \tab
total area of estimation unit \cr \tab expfac \tab strata-level expansion
factor after nonsampled plots and conditions removed (AREA_USED/n.strata)
\cr \tab EXPNS \tab strata-level area expansions (expfac * strwt)\cr }

Table(s) are also written to outfolder.
}
\description{
Generates population data for generating photo-based estimation.  Plots that
are totally nonsampled are excluded from estimation dataset. Next, an
adjustment factor is calculated by strata to adjust for nonsampled
(nonresponse) conditions that have proportion less than 1. Attributes
adjusted to a per-acre value are summed by plot, divided by the adjustment
factor, and averaged by stratum.  Strata means are combined using the strata
weights and then expanded to using the total land area in the population.
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr \tabular{llll}{ \tab \bold{Data} \tab
\bold{Variable} \tab \bold{Description}\cr \tab tree \tab tuniqueid \tab
Unique identifier for each plot, to link to pltassgn (ex. PLT_CN).\cr \tab
\tab CONDID \tab Unique identifier of each condition on plot, to link to
cond.  Set CONDID=1, if only 1 condition per plot.\cr \tab \tab TPA_UNADJ
\tab Number of trees per acre each sample tree represents (ex. DESIGNCD=1:
TPA_UNADJ=6.018046 for trees on subplot; 74.965282 for trees on
microplot).\cr \tab cond \tab cuniqueid \tab Unique identifier for each
plot, to link to pltassgn (ex. PLT_CN).\cr \tab \tab CONDID \tab Unique
identfier of each condition on plot.  Set CONDID=1, if only 1 condition per
plot.\cr \tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on
each plot.  Set CONDPROP_UNADJ=1, if only 1 condition per plot.\cr \tab \tab
COND_STATUS_CD \tab Status of each forested condition on plot (i.e.
accessible forest, nonforest, water, etc.)\cr \tab \tab NF_COND_STATUS_CD
\tab If ACI=TRUE. Status of each nonforest condition on plot (i.e.
accessible nonforest, nonsampled nonforest)\cr \tab \tab SITECLCD \tab If
landarea=TIMBERLAND. Measure of site productivity.\cr \tab \tab RESERVCD
\tab If landarea=TIMBERLAND. Reserved status.\cr \tab \tab SUBPROP_UNADJ
\tab Unadjusted proportion of subplot conditions on each plot.  Set
SUBPROP_UNADJ=1, if only 1 condition per subplot.\cr \tab \tab
MICRPROP_UNADJ \tab If microplot tree attributes. Unadjusted proportion of
microplot conditions on each plot. Set MICRPROP_UNADJ=1, if only 1 condition
per microplot.\cr \tab \tab MACRPROP_UNADJ \tab If macroplot tree
attributes. Unadjusted proportion of macroplot conditions on each plot. Set
MACRPROP_UNADJ=1, if only 1 condition per macroplot.\cr \tab pltassgn \tab
puniqueid \tab Unique identifier for each plot, to link to cond (ex. CN).\cr
\tab \tab STATECD \tab Identifies state each plot is located in.\cr \tab
\tab INVYR \tab Identifies inventory year of each plot.\cr \tab \tab
PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, nonsampled).  If not
included, all plots are assumed as sampled.\cr }

For available reference tables: sort(unique(FIESTAutils::ref_codes$VARIABLE)) \cr
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions. It is calculated for each estimation unit by strata.
by summing the unadjusted proportions of the subplot, microplot, and
macroplot (i.e. *PROP_UNADJ) and dividing by the number of plots in the
strata/estimation unit).

An adjustment factor is determined for each tree based on the size of the
plot it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr \tab SUBPLOT
\tab 6.018046 \cr \tab MICROPLOT \tab 74.965282 \cr \tab MACROPLOT \tab
0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor.  This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

unitcombine:\cr If TRUE and less than 2 plots in any one estimation unit,
all estimation units with 10 or less plots are combined. The current method
for combining is to group the estimation unit with less than 10 plots with
the estimation unit following in consecutive order (numeric or
alphabetical), restrained by survey unit (UNITCD) if included in dataset,
and continuing until the number of plots equals 10. If there are no
estimation units following in order, it is combined with the estimation unit
previous in order.

stratcombine:\cr If TRUE and less than 2 plots in any one strata class
within an esimation unit, all strata classes with 2 or less plots are
combined. The current method for combining is to group the strata with less
than 2 plots with the strata class following in consecutive order (numeric
or alphabetical), restrained by estimation unit (if unitcombine=FALSE), and
continuing until the number of plots equals 10. If there are no strata
classes following in order, it is combined with the estimation unit previous
in order.
}
\examples{
# Load necessary data from FIESTA
## Point data
icepntfn <- system.file("extdata",
                        "PB_data/icepnt_utco1135.csv",
                         package = "FIESTA")
icepnt <- read.csv(icepntfn)

## Plot data
icepltfn <- system.file("extdata",
                        "PB_data/icepltassgn_utco1135.csv",
                         package = "FIESTA")
iceplt <- read.csv(icepltfn)

# Percent land cover at Time 1 (2011) for all land in Davis and Salt Lake
# Counties, UT
PBpopdat <- modPBpop(pnt = icepnt, 
                     pltassgn = iceplt,
                     pltassgnid = "plot_id",
                     pntid = "dot_cnt")

str(PBpopdat, max.level = 1)

# We can also create population data for estimates by estimation unit
## Read in data for multiple estimation units
unitareafn <- system.file("extdata", 
                          "PB_data/unitarea_utco1135.csv",
                           package = "FIESTA")
unitarea <- read.csv(unitareafn)

## Run modPBpop
PBpopunit <- modPBpop(pnt = icepnt, 
                      pltassgn = iceplt, 
                      pltassgnid = "plot_id", 
                      pntid = "dot_cnt",
                      unitarea = unitarea, 
                      unitvar = "ESTN_UNIT")
}
\references{
Scott, Charles T.; Bechtold, William A.; Reams, Gregory A.;
Smith, William D.; Westfall, James A.; Hansen, Mark H.; Moisen, Gretchen G.
2005. Sample-based estimators used by the Forest Inventory and Analysis
national information management system. Gen. Tech. Rep. SRS-80. Asheville,
NC: U.S. Department of Agriculture, Forest Service, Southern Research
Station, p.53-77.
}
\author{
Tracey S. Frescino, Paul L. Patterson, Elizabeth A. Freeman
}
\keyword{data}
