% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{comp_pred}
\alias{comp_pred}
\title{A wrapper for competing classification algorithms}
\usage{
comp_pred(
  formula,
  data.train,
  data.test = NULL,
  algorithm = NULL,
  model = NULL,
  sens.w = NULL,
  new.factors = "exclude"
)
}
\arguments{
\item{formula}{A formula (usually \code{x$formula}, for an \code{FFTrees} object \code{x}).}

\item{data.train}{A training dataset (as data frame).}

\item{data.test}{A testing dataset (as data frame).}

\item{algorithm}{character string. An algorithm in the set:
"lr" -- logistic regression;
"rlr" -- regularized logistic regression;
"cart" -- decision trees;
"svm" -- support vector machines;
"rf" -- random forests.}

\item{model}{model. An optional existing model, applied to the test data.}

\item{sens.w}{Sensitivity weight parameter (from 0 to 1, required to compute \code{wacc}).}

\item{new.factors}{string. What should be done if new factor values are discovered in the test set?
"exclude" = exclude (i.e.; remove these cases), "base" = predict the base rate of the criterion.}
}
\description{
\code{comp_pred} provides the main wrapper for running alternative classification algorithms, such as CART (\code{rpart::rpart}),
logistic regression (\code{glm}), support vector machines (\code{svm::svm}), and random forests (\code{randomForest::randomForest}).
}
