% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_threshold_factor_grid.R
\name{fftrees_threshold_factor_grid}
\alias{fftrees_threshold_factor_grid}
\title{Perform a grid search over factor and return accuracy statistics for a given factor cue}
\usage{
fftrees_threshold_factor_grid(
  thresholds = NULL,
  cue_v = NULL,
  criterion_v = NULL,
  directions = "=",
  sens.w = 0.5,
  cost.outcomes = list(hi = 0, fa = 1, mi = 1, cr = 0),
  cost.each = 0,
  goal.threshold = "bacc"
)
}
\arguments{
\item{thresholds}{numeric. A vector of factor thresholds to consider.}

\item{cue_v}{numeric. Feature/cue values.}

\item{criterion_v}{logical. A logical vector of (TRUE) criterion values.}

\item{directions}{character. Character vector of threshold directions to consider.}

\item{sens.w}{numeric. Sensitivity weight parameter (from 0 to 1, for computing \code{wacc}).
Default: \code{sens.w = .50}.}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying
the costs of a hit, false alarm, miss, and correct rejection, respectively.
For instance, \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that
a false alarm and miss cost 10 and 20, respectively, while correct decisions have no cost.}

\item{cost.each}{numeric.}

\item{goal.threshold}{character.}
}
\value{
A data frame containing accuracy statistics for several factor thresholds
}
\description{
Perform a grid search over factor and return accuracy statistics for a given factor cue
}
\seealso{
\code{\link{fftrees_threshold_numeric_grid}} for numeric cues.
}
