% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictFFTrees_function.R
\name{predict.FFTrees}
\alias{predict.FFTrees}
\title{Predict classifications from newdata using an FFTrees object}
\usage{
\method{predict}{FFTrees}(object = NULL, newdata = NULL, data = NULL,
  tree = 1, type = "class", sens.w = NULL, method = "laplace", ...)
}
\arguments{
\item{object}{An FFTrees object created from the FFTrees() function.}

\item{newdata}{dataframe. A dataframe of test data}

\item{tree}{integer. Which tree in the object should be used? By default, tree = 1 is used}

\item{type}{string. What should be predicted? Can be \code{"class"}, which returns a vector of class predictions, or \code{"prob"} which returns a matrix of class probabilities.}

\item{sens.w, data}{depricated}

\item{method}{string. Method of calculating class probabilities. Either 'laplace', which applies the Laplace correction, or 'raw' which applies no correction.}

\item{...}{Additional arguments passed on to \code{predict()}}
}
\value{
Either a logical vector of predictions, or a matrix of class probabilities.
}
\description{
Predict classifications from newdata using an FFTrees object
}
\examples{


  # Create training and test data

  set.seed(100)
  breastcancer <- breastcancer[sample(nrow(breastcancer)),]
  breast.train <- breastcancer[1:150,]
  breast.test <- breastcancer[151:303,]

  # Create an FFTrees x from the training data

  breast.fft <- FFTrees(formula = diagnosis ~.,
                              data = breast.train)

 # Predict classes of test data
  breast.fft.pred <- predict(breast.fft,
                             data = breast.test)

 # Predict class probabilities
  breast.fft.pred <- predict(breast.fft,
                             data = breast.test,
                             type = "prob")

}
