% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuousLR.R
\name{continuous.LR}
\alias{continuous.LR}
\alias{LR}
\alias{NLR}
\title{Continuous Lehmann-Romano procedure}
\usage{
continuous.LR(
  raw.pvalues,
  alpha = 0.05,
  zeta = 0.5,
  adaptive = TRUE,
  critical.values = FALSE
)

LR(raw.pvalues, alpha = 0.05, zeta = 0.5, critical.values = FALSE)

NLR(raw.pvalues, alpha = 0.05, zeta = 0.5, critical.values = FALSE)
}
\arguments{
\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbor in the CDFs supports.}

\item{alpha}{the target FDP, a number strictly between 0 and 1. For \code{*.fast} kernels, it is only necessary, if \code{stepUp = TRUE}.}

\item{zeta}{the target probability of not exceeding the desired FDP, a number strictly between 0 and 1. If \code{zeta=NULL} (the default), then \code{zeta} is chosen equal to \code{alpha}.}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}

\item{critical.values}{a boolean. If \code{TRUE}, critical constants are computed and returned (this is computationally intensive).}
}
\value{
A \code{FDX} S3 class object whose elements are:
\item{Rejected}{Rejected raw p-values.}
\item{Indices}{Indices of rejected hypotheses.}
\item{Num.rejected}{Number of rejections.}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}

\item{Critical.values}{Critical values (if requested).}
\item{Method}{A character string describing the used algorithm, e.g. 'Discrete Lehmann-Romano procedure (step-up)'.}
\item{FDP.threshold}{FDP threshold \code{alpha}.}
\item{Exceedance.probability}{Probability \code{zeta} of FDP exceeding \code{alpha}; thus, FDP is being controlled at level \code{alpha} with confidence \code{1 - zeta}.}
\item{Adaptive}{A boolean specifying whether an adaptive procedure was conducted or not.}

\item{Data$raw.pvalues}{The values of \code{raw.pvalues}.}


\item{Data$data.name}{The respective variable names of \code{raw.pvalues} and \code{pCDFlist}.}
}
\description{
Apply the usual (continuous) [LR] procedure, with or without computing the
critical values, to a set of p-values. A non-adaptive version is available as
well.
}
\details{
\code{LR} and \code{NLR} are wrapper functions for \code{continuous.LR}. The
first one simply passes all its parameters to \code{continuous.LR} with
\code{adaptive = TRUE} and \code{NLR} does the same with
\code{adaptive = FALSE}.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports (fisher.pvalues.support
# is from 'DiscreteFDR' package!)
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

LR.fast <- LR(raw.pvalues)
summary(LR.fast)

LR.crit <- LR(raw.pvalues, critical.values = TRUE)
summary(LR.crit)

NLR.fast <- NLR(raw.pvalues)
summary(NLR.fast)

NLR.crit <- NLR(raw.pvalues, critical.values = TRUE)
summary(NLR.crit)

}
\seealso{
\code{\link{kernel}}, \code{\link{FDX-package}}, \code{\link{continuous.GR}},
\code{\link{discrete.LR}}, \code{\link{discrete.GR}}, 
\code{\link{discrete.PB}}, \code{\link{weighted.LR}}, 
\code{\link{weighted.GR}}, \code{\link{weighted.PB}}
}
