% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{hist.FDX}
\alias{hist.FDX}
\title{Histogram of Raw p-Values}
\usage{
\method{hist}{FDX}(x, breaks = "FD", main = NULL, xlab = NULL, ylab = NULL, plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class "\code{FDX}".}

\item{breaks}{as in \code{\link{hist}}; here, the Friedman-Diaconis
algorithm(\code{"FD"}) is used as default.}

\item{main}{main title. If \code{NULL} (default), a description string
is used.}

\item{xlab, ylab}{labels for x and y axis.}

\item{plot}{a boolean If \code{TRUE} (the default), a histogram is
plotted, otherwise a list of breaks and counts is returned.}

\item{...}{further arguments to \code{\link{hist}} or
\code{\link{plot.histogram}}, respectively.}
}
\value{
An object of class \code{histogram}.
}
\description{
Computes a histogram of the raw p-values of a \code{FDX} object.
}
\details{
If \code{x} contains results of a weighted approach, a histogram of the
weighted p-values is constructed. Otherwise, it is constituted by the
raw ones.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports (fisher.pvalues.support
# is from 'DiscreteFDR' package!)
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

DGR <- DGR(raw.pvalues, pCDFlist)
hist(DGR)

}
