% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.p.fdr.R
\name{print.summary.p.fdr}
\alias{print.summary.p.fdr}
\title{Print the summary of p.fdr.object}
\usage{
\method{print}{summary.p.fdr}(x, digits = 3, ...)
}
\arguments{
\item{x}{A list of output from the summary.p.fdr function.}

\item{digits}{A numeric value for the number of desired digits in the summary output. Defaults to 3.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
This function prints the summary a p.fdr.object.
}
\details{
We run into errors or warnings when
}
\examples{

# Example 1
pi0 = 0.8
pi1 = 1-pi0
n = 10
n.0 = ceiling(n*pi0)
n.1 = n-n.0

sim.data = c(rnorm(n.1,5,1),rnorm(n.0,0,1))
sim.data.p = 2*pnorm(-abs(sim.data))

fdr.output = p.fdr(pvalues=sim.data.p, adjust.method="BH")

summary(fdr.output)


}
\references{
\insertRef{Rpack:bibtex}{Rdpack}

\insertRef{R}{FDRestimation}

\insertRef{murray2020false}{FDRestimation}
}
\seealso{
\code{\link{plot.p.fdr}, \link{p.fdr}, \link{get.pi0}}
}
\concept{summary FDR adjusted p-values null proportion}
\keyword{FDR}
\keyword{p-values}
\keyword{summary}
