# FARS - Factor-Augmented Regression Scenarios

<!-- badges: start -->
[![R-CMD-check](https://github.com/GPEBellocca/FARS/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/GPEBellocca/FARS/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

The `FARS` package provides a comprehensive framework in R for modeling and forecasting economic scenarios based on the multi-level dynamic factor model (MLDFM). The package enables users to:

- (i) Extract global and block-specific factors using a flexible multilevel factor structure.
- (ii) Compute asymptotically valid confidence regions for the estimated factors, accounting for uncertainty in the factor loadings.
- (iii) Estimate factor-augmented quantile regressions.
- (iv) Recover full predictive densities from these quantile forecasts.
- (v) Estimate the density when the factors are stressed.

# Installation and Usage
For  detailed usage and examples, including stress testing, quantile regression, and more, please refer to the [FARS Vignette](./vignettes/introduction.Rmd).
The Vignette example is based on: 
González-Rivera, G., Rodríguez-Caballero, C. V., & Ruiz, E. (2024). Expecting the unexpected: Stressed scenarios for economic growth. Journal of Applied Econometrics, 39(5), 926–942. https://doi.org/10.1002/jae.3060

![FARS Logo](https://gpebellocca.weebly.com/uploads/1/4/3/4/143433954/fars-logo-copia_orig.png)
