% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FADPsummary.R
\name{FADPsummary}
\alias{FADPsummary}
\title{Summary of FADPclust}
\usage{
FADPsummary(object)
}
\arguments{
\item{object}{object of class 'FADPclust' that is returned from FADPclust().}
}
\description{
Summarize the result obetained from the FADPclust() function.
}
\examples{
###univariate functional data
data("simData1")
plot(simData1, xlab = "x", ylab = "y")
FADP1.ans <- FADPclust(fdata = simData1, cluster = 2:10, method = "FADP1",
                       proportion = seq(0.02, 0.2, 0.02))
FADP2.ans <- FADPclust(fdata = simData1, cluster = 2:10, method = "FADP2",
                     proportion = seq(0.02, 0.2, 0.02), pve = 0.9)
FADPsummary(FADP1.ans); FADPplot(FADP1.ans)
FADPsummary(FADP2.ans); FADPplot(FADP2.ans)

\donttest{
###multivariate functional data
data("simData2")
FADP1.ans <- FADPclust(fdata = simData2, cluster = 2:10, method = "FADP1",
                       proportion = seq(0.02, 0.2, 0.02), pve = 0.9)
FADP2.ans <- FADPclust(fdata = simData2, cluster = 2:10, method = "FADP2",
                     proportion = seq(0.02, 0.2, 0.02), pve = 0.9)
FADPsummary(FADP1.ans); FADPplot(FADP1.ans)
FADPsummary(FADP2.ans); FADPplot(FADP2.ans)
}
}
\seealso{
\code{\link{FADPclust}}, \code{\link{FADPplot}}.
}
