\name{dmest}
\alias{dmest}
\alias{pmest}

\title{Bivariate and trivariate extended skew-t distribution}
\description{Density function, distribution function for the bivariate and trivariate extended skew-t (\acronym{EST}) distribution.}

\usage{
dmest(x=c(0,0), location=rep(0, length(x)), scale=diag(length(x)),
      shape=rep(0,length(x)), extended=0, df=Inf)
pmest(x=c(0,0), location=rep(0, length(x)), scale=diag(length(x)),
      shape=rep(0,length(x)), extended=0, df=Inf)
}
\arguments{
	\item{x}{ quantile vector of length \code{d=2} or \code{d=3}. }
	\item{location}{a numeric location vector of length \code{d}. \code{0} is the default.}
	\item{scale}{a symmetric positive-definite scale matrix of dimension \code{(d,d)}. \code{diag(d)} is the default.}
	\item{shape}{a numeric skewness vector of length \code{d}. \code{0} is the default.}
	\item{extended}{a single value extension parameter. \code{0} is the default.}
	\item{df}{a single positive value representing the degree of freedom;
  		it can be non-integer. Default value is \code{nu=Inf} which corresponds
  		to the skew-normal distribution.}
}

\value{
	density (\code{dmest}), probability (\code{pmest}) from the bivariate or trivariate extended skew-t distribution with given
	\code{location}, \code{scale}, \code{shape}, \code{extended} and \code{df} parameters or from the skew-t distribution if \code{extended=0}.
	If \code{shape=0} and \code{extended=0} then the t distribution is recovered.
 }

\references{
  Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry
  with emphasis on a multivariate skew \emph{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.

  Azzalini, A. with the collaboration of Capitanio, A. (2014).
  \emph{The Skew-Normal and Related Families}.
  Cambridge University Press, IMS Monograph series.
}

\examples{

sigma1 <- matrix(c(2,1.5,1.5,3),ncol=2)
sigma2 <- matrix(c(2,1.5,1.8,1.5,3,2.2,1.8,2.2,3.5),ncol=3)
shape1 <- c(1,2)
shape2 <- c(1,2,1.5)

dens1 <- dmest(x=c(1,1), scale=sigma1, shape=shape1, extended=2, df=1)
dens2 <- dmest(x=c(1,1), scale=sigma1, df=1)
dens3 <- dmest(x=c(1,1,1), scale=sigma2, shape=shape2, extended=2, df=1)
dens4 <- dmest(x=c(1,1,1), scale=sigma2, df=1)

prob1 <- pmest(x=c(1,1), scale=sigma1, shape=shape1, extended=2, df=1)
prob2 <- pmest(x=c(1,1), scale=sigma1, df=1)

\donttest{
prob3 <- pmest(x=c(1,1,1), scale=sigma2, shape=shape2, extended=2, df=1)
prob4 <- pmest(x=c(1,1,1), scale=sigma2, df=1)
}

}

\author{
	Simone Padoan, \email{simone.padoan@unibocconi.it},
	\url{https://faculty.unibocconi.it/simonepadoan/};
	Boris Beranger, \email{borisberanger@gmail.com}
	\url{https://www.borisberanger.com};
}

\keyword{distribution}
