% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_segmentation.R
\name{pick_segmentation}
\alias{pick_segmentation}
\title{Segmenting objects manually (Segmentação de objetos manualmente)}
\usage{
pick_segmentation(im,num.points=NULL, col="red")
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{num.points}{:Maximum number of points to be used to delimit the object
(Número maximo de pontos a ser utilizado para delimitar o objeto).}

\item{col}{: Color of points and lines that delimit the object
(Cor dos pontos e linhas que delimitarão o objeto)}
}
\value{
Returns an image with pixel values equal to 1(white) for the foreground and 0 (black)
 for the foreground (Retorna uma imagem com valores de pixel igual a 1( branco) para o foreground
  e 0 (preto) para o foreground).
}
\description{
With this function it is possible to segment objects by clicking on their boundaries
(Com essa funcao e possivel segmentar objetos clicando em suas delimitacoes).
}
\examples{

\dontrun{
require(ExpImage)
im=read_image(example_image(3),plot=TRUE)
mask=pick_segmentation(im)
im2=extract_pixels(im,mask,plot = TRUE,valueTarget = 1)
crop_image(im2,segmentation = mask,plot=TRUE)
im3=extract_pixels(im,mask,plot = TRUE,valueTarget = 0)
}
}
\seealso{
\code{\link{segmentation}} , \code{\link{segmentation_logit}}, \code{\link{segmentation_logitGUI}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
