% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_logitGUI.R
\name{segmentation_logitGUI}
\alias{segmentation_logitGUI}
\title{Funcao para a segmentacao de imagens.}
\usage{
segmentation_logitGUI(im,return="image",sample=2000,
 fillHull=FALSE,TargetPixels="all")
}
\arguments{
\item{im}{:Este objeto deve ser obrigatoriamente uma imagem colorida (RGB)
no formato do EBImage).}

\item{return}{Texto indicando o objeto a ser exportado pela funcao. Para
este argumento podemos considerar: \cr
  "image" = sera exportada uma matriz referente a imagem segmentada.\cr
  "model" = Sera exportado o modelo para a predicao.\cr}

\item{sample}{: Deve ser um valor numerico indicando quantos pixels dos
imagens do foreground e do background serao utilizados no ajuste do modelo
logit. O valor a ser escolhido deve ser inferior ou igual ao numero de
pixels contidos nas paletas de cores.}

\item{fillHull}{:Este argumento deve receber a palavra TRUE quando se
pretende desconsiderar valores vazios dentro do foreground, caso contrario
FALSE.}

\item{TargetPixels}{:Quando se pretende segmentar todos os pixeis da imagem
deve considerar a palavra "all" (Default). Se a segmentacao deva ser feita
apenas para um conjunto de pixels, estes devem ser apresentados em uma
matriz contendo o valor 1 para os pixels de interesse e 0 para os demais.}
}
\value{
Imagem segmentada
}
\description{
Esta funcao possibilita a segmentacao de imagens por meio de do
 ajuste de um modelo linear generalizado com a funcao logit de ligacao.
}
\examples{
\donttest{

#################################################################
#Estimar a area foliar usando um objeto de referencia.
##################################################################
  #ativar pacote
  #library(EBImage)
  #library(ExpImage)
  #######################################################
  #Abrir imagem das folhas
  im=read_image(example_image(3))
  plot_image(im)
  #Abrir paleta de cores do fundo
  fundo=read_image(example_image(4))
  plot_image(fundo)
  #Abrir paleta de cores das folhas
  folhas=read_image(example_image(5))
  plot_image(folhas)
  #Abrir paleta de cores referencia
  ref=read_image(example_image(6))
  #Ver a imagem
  plot_image(ref)

  #################################################################
  #Segmentacao para separar as folhas do restante
  folhas.seg=segmentation_logit(im,foreground=folhas,
  background=list(fundo,ref),sample=2000,fillHull=TRUE,plot=TRUE)

  #Segmentacao para separar o objeto de referencia do restante
  ref.seg=segmentation_logit(im,foreground=ref,
  background=list(fundo,folhas),sample=2000,fillHull=TRUE,plot=TRUE)

  #Identificar area de cada folha

  medidas=measure_image(folhas.seg,noise = 1000)
  #numero de objetos e medias
  medidas

  #Plotar resultados das areas em pixel e salvar em imagem jpg
  plot_meansures(im,medidas$measures[,1],coordy=medidas$measures[,2],
  text=round(medidas$measures[,3],1),col="blue",cex = 0.9,pathSave ="none" ,plot=TRUE)
  }
}
\seealso{
\code{\link{glm}} ,\code{\link{segmentation}}
}
\author{
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
