% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_steps.R
\name{segmentation_steps}
\alias{segmentation_steps}
\title{Image segmentation function (Funcao para a segmentacao de imagens).}
\usage{
segmentation_steps(img,indexes=c("b","b"),threshold=c("otsu",0.6),
selectHigher=c(TRUE,FALSE),fillHull=c(TRUE,FALSE),fillBack=c(TRUE,FALSE),
thresholdFinish="otsu", selectHigherFinish=TRUE, fillHullFinish=TRUE,
fillBackFinish=TRUE,plot=FALSE)
}
\arguments{
\item{img}{:Este objeto deve ser obrigatoriamente imagem colorida do formato EBImage/ExpImage.}

\item{indexes}{: Deve ser um vetor contendo os indices a serem utilizados em cada etapa
de segmentacao. As opcoes de indices sao:\cr
   "r" = extrair a banda de vermelho\cr
   "g" = extrair a banda de verde\cr
    "b" = extrair a banda de azul\cr
   "rg" = considera a media da banda de vermelho e verde: (r+g)/2\cr
   "rb" = considera a media da banda de vermelho e azul: (r+b)/2\cr
   "gb" = considera a media da banda de verde e azul: (g+b)/2\cr
  "rgb" = considera a media das 3 bandas: (r+g+b)/3\cr
   "BI"=sqrt((r^2+g^2+b^2)/3)\cr
   "BIM"=sqrt((2r+2g+2b)/3)\cr
   "SCI"=(r-g)/(r+g)\cr
   "GLI"=(2g-r-b)/(2g+r+b)\cr
   "HI"=(2r-g-b)/(g-b)\cr
   "NGRDI"=(g-r)/(g+r)\cr
   "SI"=(r-b)/(r+b)\cr
   "VARI"=(g-r)/(g+r-b)\cr
   "HUE"=atan(2(b-g-r)/30.5(g-r))\cr
   "MGVRI"=(g^2-r^2)/(g^2+r^2)\cr
   "GLI"=(2g-r-b)/(2g+r+b)\cr
   "MPRI"=(g-r)/(g+r)\cr
   "RGVBI"=(g-(br))/(g^2(br))\cr
   "ExG"=(2*g-r-b)\cr
   "VEG"=(g/(g^0.66667*b^0.66667))\cr}

\item{threshold}{: E um vetor com valores numericos entre 0 e 1 a ser considerado como
limiar. O usuario pode tambem usar o argumento "ostu", caso queira
considerar o limiar estabelecido por essa metodologia.}

\item{selectHigher}{:Este argumento deve se um vetor com as palavras TRUE ou
FALSE. TRUE e quando se quer selecionar pixels de valores  maiores que o
limiar. FALSE quando se deseja selecionar valores menores.}

\item{fillHull}{:Este argumento deve se um vetor com as palavras TRUE quando se
pretende desconsiderar valores vazios dentro do foreground, caso contrario
FALSE.}

\item{fillBack}{:Este argumento deve se um vetor com as TRUE quando se
pretende desconsiderar valores vazios dentro do background, caso contrario
FALSE.}

\item{thresholdFinish}{E um valor entre 0 e 1 a ser considerado como
limiar na ultima segmentacao. O usuario pode tambem usar o argumento "ostu", caso queira
considerar o limiar estabelecido por essa metodologia.}

\item{selectHigherFinish}{argumento com as palavras TRUE ou
FALSE. TRUE (default) e quando se quer selecionar pixels de valores  maiores que o
limiar na ultima segmentacao. FALSE quando se deseja selecionar valores menores.}

\item{fillHullFinish}{:Este argumento deve ser TRUE quando se
pretende desconsiderar valores vazios dentro do foreground na ultima segmentacao, caso contrario
FALSE.}

\item{fillBackFinish}{:Este argumento deve ser TRUE quando se
pretende desconsiderar valores vazios dentro do background na ultima segmentacao, caso contrario
FALSE.}

\item{plot}{:Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem segmentada.}
}
\value{
Imagem segmentada
}
\description{
Esta funcao possibilita a segmentacao de imagens por meio de um
  limiar. Para isso, pode-se escolher um valor arbtrario ou considerar o
  valor estabelecido pelo metodo otsu.
}
\examples{
\donttest{
############################################################################
#Obtendo o numero de ovos em uma folha
############################################################################

#Carregar imagem de exemplo
im=read_image(example_image(2),plot=TRUE)
## Fazendo a segmentacao na imagem
m=segmentation_steps(img=im,
indexes=c("b","b"),
threshold=c(0.39,0.7),
selectHigher=c(FALSE,TRUE),
fillHull=c(TRUE,TRUE),
fillBack=c(FALSE,FALSE),
thresholdFinish = 0.5,
selectHigherFinish = TRUE,
fillHullFinish = FALSE,
plot=TRUE)
measure_image(m,splitConnected = FALSE)
#Ver a mascara sobre os ovos na foto
im3=mask_pixels(im,m==1,plot=TRUE)
}
}
\seealso{
\code{\link{segmentation_logit}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
