% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_file.BorderExtract.R
\name{shape_file.BorderExtract}
\alias{shape_file.BorderExtract}
\title{Excluir as bordas do objetos/parcelas do shapefile}
\usage{
shape_file.BorderExtract(im, ShapeFile,p.rows=0.5,p.cols=0.5,col1="red",col2="white")
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage/ExpImage.}

\item{ShapeFile}{Objeto criado pela funcao shape_file.create}

\item{p.rows}{E a porcentagem de interesse das parcela no sentido das linhas. Deve variar entre 0 e 1.}

\item{p.cols}{E a porcentagem de interesse das parcela no sentido das colunas. Deve variar entre 0 e 1.}

\item{col1}{Nome da cor das linhas do grid que serao apresentadas. Default e "red".}

\item{col2}{Nome da cor das linhas da parcela correspondente a area de interesse. Default e "white".}
}
\value{
Obtem as coordenadas na imagem dispensando a area da bordadura
(Obtains the coordinates in the image excluding the border area).
}
\description{
Esta funcao exclui as bordas (bordadura) dos objetos/parcelas selecionadas pela
funcao shape_file.create.
}
\examples{
\dontrun{
# Not run: Depende da interacao com uma interface grafica
#(It depends on interaction with a graphical interface).

end=example_image(13)
im=read_image(end,plot=TRUE)
A=shape_file.create(im,rows=5,cols=5,rectangular=F,Matrix=NULL,SelectSeveral = F)
B=shape_file.BorderExtract(im,A,p.rows = .9,p.cols = .9)
shape_file.plot(im,ShapeFile = B)
shape_file.split(im =im,shapefile = B,path = getwd(),namesFile = "TEST",type = ".jpg")
}
}
\seealso{
\code{\link{shape_file.create}}, \code{\link{shape_file.split}}
}
