% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_definition.R
\name{somatic.CNV.call}
\alias{somatic.CNV.call}
\title{somatic.CNV.call}
\usage{
somatic.CNV.call(normal, tumor, prop.tumor = 1, chromosome, start, end, names)
}
\arguments{
\item{normal}{Read count data (numeric vector) for the normal tissue.}

\item{tumor}{Read count data (numeric vector) for the tumor.}

\item{prop.tumor}{Proportion of the tumour DNA in the tumour sample (between 0 and 1, and less than 1 if there is normal tissue in the tumor sample).}

\item{chromosome}{Chromosome information for the bins.}

\item{start}{Start position of each bin (typically in bp).}

\item{end}{End position of each bin.}

\item{names}{Names for each bin (tyically exon names but any way to track
the bins will do).}
}
\value{
An ExomeDepth object with CNV calls.
}
\description{
Call somatic variants between healthy and disease tissues.
}
\details{
Use read depth data from targeted sequencing experiments to call CNV between
a tumor and matched healthy tissue. This is an experimental function at this stage.
}
\note{
Absolutely experimental, not the main function from the package.
}
