% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phaseDiagram3S.R
\name{phaseDiagram3S}
\alias{phaseDiagram3S}
\title{Phase Diagram for two-player games with three strategies}
\usage{
phaseDiagram3S(A, dynamic, params = NULL, trajectories = NULL,
  contour = FALSE, vectorField = FALSE, strategies = c("1", "2", "3"))
}
\arguments{
\item{A}{Numeric matrix of size 3x3 representing the number of strategies of
a symmetric matrix game.}

\item{dynamic}{Function representing an evolutionary dynamic.}

\item{params}{Numeric vector with additional parameters for the evolutionary
dynamic.}

\item{trajectories}{Numeric matrix of size mx3. Each row represents the
initial values for the trajectory to be examined.}

\item{contour}{Logical value that handles contour diagram presentation. If
set to \code{TRUE}, contour diagram will be shown, otherwise not. Default
is \code{FALSE}.}

\item{vectorField}{Logical value that handles vector field presentation. If
set to \code{TRUE}, vector field will be shown, otherwise not. Default is
\code{FALSE}.}

\item{strategies}{String vector of length 3 that names all strategies.}
}
\value{
None.
}
\description{
Plots phase diagram of a game with two players and three
 strategies.
}
\examples{
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3), 1, 3, byrow=TRUE)

phaseDiagram3S(A, Replicator, NULL, state, FALSE, FALSE)
phaseDiagram3S(A, Replicator, NULL, state, TRUE, TRUE)

# Plot two trajectories rather than only one:
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3, 0.6, 0.2, 0.2), 2, 3, byrow=TRUE)
phaseDiagram3S(A, Replicator, NULL, state, FALSE, FALSE)
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
