% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods-data.R
\docType{data}
\name{ncLikelihoods}
\alias{ncLikelihoods}
\title{Example profile likelihoods for negative control outcomes}
\format{
An object of class \code{list} containing 12 lists, where each list includes
several dataframes ith column \code{point} and \code{value} for adaptive grid profile likelihoods.
}
\usage{
ncLikelihoods
}
\description{
A list that contain profile likelihoods a large set of negative control outcomes.
They are extracted from a real-world observational healthcare database, with the
likelihoods profiled using adaptive grids using the \code{Cyclops} package.
}
\examples{
data("ncLikelihoods")
ncLikEx <- ncLikelihoods[["5"]][[1]]
\donttest{
plot(value ~ point, data = ncLikEx)
}
}
\references{
Schuemie et al. (2022). Vaccine safety surveillance using routinely collected
healthcare data—an empirical evaluation of epidemiological designs. Frontiers in Pharmacology.
}
\keyword{datasets}
