/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.data.CoxData;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.CoxPartialLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;

public class JointAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final OperatorSchedule schedule;
    private final Parameter beta = new Parameter.Default("beta", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);

    public JointAnalysis(CoxData data, double betaPriorSd) {
        this(data.getSortedData(), betaPriorSd);
    }

    public JointAnalysis(SortedCoxData data, double betaPriorSd) {
        this.likelihood = new CoxPartialLikelihood(this.beta, data);
        DistributionLikelihood betaPrior = new DistributionLikelihood((Distribution)new NormalDistribution(0.0, betaPriorSd));
        betaPrior.addData((Attribute)this.beta);
        this.prior = betaPrior;
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double defaultWeight = 1.0;
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(this.beta, null, 0.75, condition, defaultWeight, mode));
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        this.likelihood.setId("likelihood");
        this.prior.setId("prior");
        ArrayList<Loggable> columns = new ArrayList<Loggable>();
        columns.add((Loggable)this.likelihood);
        columns.add((Loggable)this.prior);
        columns.add((Loggable)this.beta);
        return columns;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    private static SortedCoxData parseDataFile(String fileName) {
        return null;
    }

    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        int[] outcome = nArray;
        double[] time = new double[]{4.0, 3.0, 3.0, 2.0, 2.0, 1.0, 1.0};
        double[] x = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        int[] nArray2 = new int[7];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        int[] strata = nArray2;
        CoxData data = new CoxData(strata, outcome, time, x);
        JointAnalysis analysis = new JointAnalysis(data, 1000.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
    }
}

