/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.inference.distribution.SplineInterpolatedLikelihood;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class EmpiricalDataModel
extends DataModel.Base
implements DataModel {
    public EmpiricalDataModel(String fileName) {
        this();
        File file = new File(fileName);
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            Scanner inputStream = new Scanner(file);
            while (inputStream.hasNext()) {
                String line = inputStream.next();
                String[] values = line.split(",");
                lines.add(Arrays.asList(values));
            }
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        double[] x = EmpiricalDataModel.parseRow((List)lines.get(0), true);
        int i = 1;
        while (i < lines.size()) {
            this.addLikelihoodParameters(x, EmpiricalDataModel.parseRow((List)lines.get(i), false));
            ++i;
        }
        this.finish();
    }

    public EmpiricalDataModel() {
    }

    private static double[] parseRow(List<String> row, boolean strip) {
        double[] values = new double[row.size()];
        int i = 0;
        while (i < row.size()) {
            String string = row.get(i);
            if (strip) {
                string = string.replace("\"", "");
            }
            values[i] = Double.parseDouble(string);
            ++i;
        }
        return values;
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> dataList) {
        return new SplineInterpolatedLikelihood(dataList, 1, false);
    }
}

