% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ILR_path}
\alias{ILR_path}
\title{Infection Link Residual Test (Path Explicit)}
\usage{
ILR_path(kvalues, E, I, tr, ti, te, alpha, beta, n, stb, path)
}
\arguments{
\item{kvalues}{a nxn symmetric matrix where n is total number of subjects in the population. Entry at position (i,j) is the value of the spatial kernel \eqn{K(d_{i,j})} where  \eqn{d_{i,j}} is the Euclidean distance between i and j. Diagonal entries are equal to 1.}

\item{E}{a vector contains the indices of infected cases excludingt the first case. Note that subjects are indexed from 0 (not 1).}

\item{I}{a vector contains the indices of infectious cases (being infectious or once infectious).}

\item{tr}{a vector contains the recovery times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).}

\item{ti}{a vector contains the times of becoming infectious of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). For a SIR model, {\code{ti}} set to be {\code{te}}}

\item{te}{a vector contains the infection times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).}

\item{alpha}{the background infection rate}

\item{beta}{the secondary infection rate}

\item{n}{the total number of subjects}

\item{stb}{a vector contains the susceptibility of subjects (entries may set to be 1 if to be ignored).}

\item{path}{a vector contains the source of infection of the cases (entries for background infections and non-infected should be specified to be 9999 and -99 respectively).}
}
\value{
a vector contains the set of  imputed residual for infected in the order of indexing.
}
\description{
Infection-link Residual Test (Path Explicit).
}
\details{
The residual test specifically designed to test the goodness-of-fit of a spatial kernel.
Explicit sources of infections are required.
}
\examples{
data(epi)

set.seed(1)

n <- nrow(epi)

kvalues_rk <- kvalues_wk <- matrix(NA,nrow=n, ncol=n)
\dontrun{kvalues_wk is to be computed from an arbitrary wrong spatial kernel below}
diag(kvalues_rk) <- diag(kvalues_wk) <- 1
for (i in 1:n){
for (j in 1:n){
	if (i<j) {
		d_ij <- sqrt((epi$coor_x[i]-epi$coor_x[j])^2 + (epi$coor_y[i]-epi$coor_y[j])^2)
		kvalues_rk[i,j] <- exp(-0.02*(d_ij))
		kvalues_wk[i,j] <- 1.0/(d_ij^1.0)
	}
	if (i>j) {
		kvalues_rk[i,j] <- kvalues_rk[j,i]
		kvalues_wk[i,j] <- kvalues_wk[j,i]
	}
}
}

E <- epi$k[which(epi$te!=9e+100 & epi$te!=min(epi$te))]
I <- epi$k[which(epi$ti!=9e+100)]
tr <- epi$tr
ti <- epi$ti
te <- epi$te
stb <- epi$stb
alpha <- 0.002
beta <- 8
infected_source <- epi$infected_source

par(mfrow=c(1,2),mar=c(4,4,4,4))
hist(ILR_path(kvalues_rk,E,I,tr,ti,te,alpha,beta,n,stb,infected_source),
main="Correct Model",xlab="ILR")
hist(ILR_path(kvalues_wk,E,I,epi$tr,ti,te,alpha,beta,n,stb,infected_source),
main="Wrong Model",xlab="ILR")
}
\author{
Max S.Y. Lau <maxlauhk54@gmail.com>
}
\references{
Lau, Max SY, George Streftaris, Glenn Marion, Gavin J. Gibson. "New model diagnostics for spatio-temporal systems in epidemiology and ecology." Journal of The Royal Society Interface 11.93 (2014): 20131093.
}

